# $Id: Templates.pm 51058 2023-10-11 10:06:51Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/pwdmodifier-pg/libpwdmodifier/lib/UvT/PwdModifier/Templates.pm $

use strict;
use warnings FATAL => 'all';

package UvT::PwdModifier::Templates;

use IO::File;
use Exporter qw(import);
use UvT::PwdModifier::Replacer;

our @EXPORT = qw(readtemplates);

sub _flatten {
	my $immediate = shift;
	if(@_) {
		return $immediate
			? join("\n", $immediate, @_, '')
			: join("\n", @_, '')
	} else {
		return $immediate || ''
	}
}

sub _replacable {
	return new UvT::PwdModifier::Replacable(&_flatten);
}

sub readtemplates {
	my %result;

	foreach my $filename (@_) {
		my $fh = new IO::File($filename, '<:utf8')
			or die "Can't open configuration file '$filename': $!\n";;

		my ($key, @values, $ws);

		while(my $line = $fh->getline) {
			next if ord($line) == 35; #
			$line =~ s/\s+$//;
			if($line eq '') {
				$ws = 1;
				next;
			}
			if($line =~ s/^\s//) {
				unless($key) {
					my $lineno = $fh->input_line_number;
					die "Line continuation before key at $filename:$lineno\n";
				}
				if($ws) {
					push @values, '';
					undef $ws;
				}
				push @values, $line;
			} else {
				$result{$key} = _replacable(@values)
					if $key;
				@values = ();
				($key, my $val) = split(/\s*=\s*/, $line, 2);
				unless($key) {
					my $lineno = $fh->input_line_number;
					die "Malformed line at $filename:$lineno\n";
				}
				push @values, $val;
				undef $ws;
			}
		}

		die "Can't read from configuration file '$filename': $!\n"
			unless $fh->eof;

		$result{$key} = _replacable(@values)
			if $key;

		$fh->close;
	}

	return \%result;
}

1
