# $Id: AAA.pm 51058 2023-10-11 10:06:51Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/pwdmodifier-pg/libpwdmodifier/lib/UvT/PwdModifier/AAA.pm $

use strict;
use warnings FATAL => 'all';

package UvT::PwdModifier::AAA;

use Spiffy -Base;
use Data::Dumper;

field 'cf', -init => 'die "no cf configured\n"';
field 'dir', -init => 'die "no directory specified\n"';
#field 'corestaffFilter', - init => 'die "no protectCorestaffFilter specified\n"';

sub verify_password {
	return $self->dir->verify_password(@_);
}

sub verify_ipaddress {
	my $ipaddress = shift;

	my $cf = $self->cf;
	my $adminipacl = $cf->value('adminipacl');
	die $cf->error if $cf->error;

	return if $ipaddress =~ /$adminipacl/;
	return "address: '$ipaddress' outside of range ($adminipacl)";
}

sub isCorestaff {
	my $dir = $self->dir;
	my $victim = shift;
	my $cf = $self->cf;
	my $corestaffFilter = "|";

	my @corestaffFilterList = $cf->value('corestaffFilters');
	foreach my $filterElement (@corestaffFilterList){
		# verwijder leading spaces, anders worden die ook omgezet in \20
		$filterElement =~ s/^\s+//;
		$corestaffFilter .= $filterElement;
	}
	$corestaffFilter =~ s{\s}{\\20}g;

	my $filter = "(&(uid=$victim)($corestaffFilter))";
#	warn "coreStaffFilter: $filter";
	my $entries = $dir->getLdapEntriesByFilter($filter);
	return @$entries[0];
}

sub verify_authorization {
	my ($admin, $victim, $privParam, $checkCorestaff) = @_;
	my $priv = 'pwd_change';
	$priv = $privParam if $privParam;
	my $reqAcc = "readOnly";
	$reqAcc = $checkCorestaff if $checkCorestaff;

	warn "verifying authorization, admin: $admin, victim: $victim, priv: $priv, requestedAccess: $reqAcc";

	if ($reqAcc eq "checkCorestaff" ) {
		return "Explanation: No changes allowed for account: $victim."
			if ($self->isCorestaff($victim));
	}

	my $dir = $self->dir;

 	# 1) fetch de org.stat. van het victim en zijn uvt-lau attrs
	my ($entry, $err) = $dir->getAccount($victim);
	return $err || 'failed' unless $entry;

	my @orgstats = $entry->orgstats;
	my @uvtlaus = $entry->laus;
	#	warn "orgstats: @orgstats";
	#	warn "uvtlaus: @uvtlaus";

	# 2) stel een lijst samen
	my %auths = ("$priv" => undef);
	foreach my $orgstat (@orgstats) {
		$orgstat = lc $orgstat;

		undef $auths{"$priv/$orgstat"};
		foreach my $uvtlau (@uvtlaus) {
			$uvtlau = lc $uvtlau;
			undef $auths{"$priv/$uvtlau/$orgstat"};
			undef $auths{"$priv/$uvtlau"};
		}
	}

	# 3) zoek op die lijst
	$err = $dir->check_uvt_auth($admin, [keys %auths]);
	if($err) {
		warn "admin: $admin is not authorized";
		return "$err, $admin is not allowed to administrate account: $victim";
	}

	warn "admin: $admin is authorized to administrate account: $victim";
	return;
}
