$(function() {
	function carp(msg) {
		if(window.console)
			console.debug(msg);
		else
			setTimeout(function() { throw new Error(msg) }, 0);
	}

	function confess(msg) {
		var e = msg === undefined ? new Error : new Error(msg);
		carp(e.stack);
		throw e;
	}

	function cluck(msg) {
		if(window.console) {
			console.debug((new Error).stack);
			if(msg !== undefined)
				console.debug(msg);
			console.debug("console.debug");
		} else {
			setTimeout(function() { throw msg === undefined ? new Error : new Error(msg) }, 0);
		}
	}

	$('#mainContentContainer').height('auto');

	var $searchForm = $('#searchForm');
	if(!$searchForm.length)
		return;

	var $searchTextInput = $('#searchTextInput');
	$searchTextInput.focus();

	var $kikiAlias = $('#kikiAlias');

	var nonce;
	var domains_by_name;

	function qnonce() {
		return '?nonce=' + encodeURIComponent(nonce);
	}

	var domain_implicated = {
		'address-exists': true,
		'empty-domain': true,
		'unknown-domain': true,
		'internal-domain': true
	};

	var feedback_texts = {
		'address-exists': "This address is already in use for another person or alias.",
		'duplicate-mailbox': "This mailbox already belongs to someone else.",
		'empty-localpart': "No name specified.",
		'empty-addressbook': "Addressbook not specified.",
		'empty-destinations': "No destinations specified.",
		'empty-domain': "Domain required.",
		'has-referrers': "Alias is still in use by other aliases. Hint: search for the full address to see all referrers.",
		'internal-domain': "This mailbox domain loops back to me – it should instead be an external mail host.",
		'invalid-address': "Invalid e-mail address.",
		'malformed-localpart': "Specified name is malformed.",
		'multiple': "Only one e-mail address allowed per field.",
		'localpart-too-long': "Specified name is too long.",
		'localpart-not-unique': "This name exists in multiple domains.",
		'person': "Attempt to update a personal record.",
		'session': "Your session expired. Please reload the page.",
		'stored': "Saved.",
		'unknown-alias': "Can't find an alias by this name.",
		'unknown-anr': "Unknown ANR.",
		'unknown-domain': "Domain cannot be resolved."
	};

	var disabled_message = "Mail delivery for this person has not been enabled yet. Contact IAM for details.";

	function feedback_text(k) {
		if(k === undefined)
			return '';
		var t = feedback_texts[k];
		return t === undefined ? k : t;
	}

	function bool2text(b, f) {
		if(b === true)
			return 'true';
		if(b === false)
			return 'false';
		return f;
	}

	function text2bool(b, f) {
		if(b === 'true')
			return true;
		if(b === 'false')
			return false;
		return f;
	}

	function sortedEach(a, f, cmp) {
		var ks = [];
		for(var k in a)
			ks.push(k);
		if(cmp === undefined)
			ks.sort();
		else
			ks.sort(cmp);
		var len = ks.length;
		var res = [];
		for(var i = 0; i < len; i++) {
			var k = ks[i];
			res.push(f(i, k, a[k]));
		}
		return res;
	}

	var typePriority = {
		alias: 3,
		person: 2,
		external: 1
	};

	function sortedTypes(a, f) {
		return sortedEach(a, f, function(a, b) {
			var ap = typePriority[a];
			var bp = typePriority[b];
			if(ap === undefined)
				ap = 0;
			if(bp === undefined)
				bp = 0;
			var c = bp - ap;
			if(c)
				return c;
			return a < b ? -1 : a > b ? 1 : 0;
		});
	}

	function domainDisplayName(names) {
		var len = names.length;
		var name = names[0];
		if(len > 1) {
			var sep = ' (';
			for(var i = 1; i < len; i++) {
				name += sep;
				name += names[i];
				sep = ', ';
			}
			name += ')';
		}
		return name;
	}

	function full(a) {
		return a.address ? a.address
			: a.labels ? full(a.labels[0])
			: a.localpart + '@' + a.domain;
	}

	function localpart(a) {
		if(a === undefined || !a.replace)
			cluck(a);
		var l = a.replace(/@[^@]*$/, '');
		if(l === a)
			return undefined;
		return l;
	}

	function domainpart(a) {
		if(a === undefined || !a.replace)
			cluck(a);
		var d = a.replace(/^.*@/, '');
		if(d === a)
			return undefined;
		return d;
	}

	function inputColor(val, orig, good, bad) {
		if(val === bad)
			return '#fee';
		else if(val === orig)
			return '#fff';
		else if(val === good)
			return '#efe';
		else if(orig === undefined && val === '')
			return '#fff';
		else
			return '#ffe';
	}

	function setInputColor($input, orig, good, bad) {
		$input.css('background-color', inputColor($input.val(), orig, good, bad));
	}

	// In sommige gevallen is een invoer alleen fout voor een combinatie van
	// waarden. Bijvoorbeeld, als het probleem is dat een alias al bestaat, dan
	// kun je dat oplossen door ofwel de localpart ofwel het domein te wijzigen.
	// In die gevallen is zowel bad1 als bad2 gedefinieerd.
	function setInputColor2($input1, $input2, orig1, orig2, good1, good2, bad1, bad2) {
		var val1 = $input1.val();
		var val2 = $input2.val();
		if(bad1 !== undefined && bad2 !== undefined && (val1 !== bad1 || val2 !== bad2)) {
			// Dit is het geval waar het om gaat: zowel bad1 als bad2 zijn gedefinieerd,
			// maar (tenminste) één van beide waarden is in de interface al veranderd.
			// Doe dan alsof geen van beide een foute waarde kent, zodat het normale
			// algoritme zijn werk kan doen.
			bad1 = undefined;
			bad2 = undefined;
		}
		$input1.css('background-color', inputColor(val1, orig1, good1, bad1));
		$input2.css('background-color', inputColor(val2, orig2, good2, bad2));
	}

	function onChange($input, handler) {
		$input.change(handler);
		$input.keyup(handler);
		$input.keydown(handler);
		$input.blur(handler);
		$input.bind('input', handler);
		$input.bind('propertychange', handler);
	}

	function ExpandedLabel(person, v) {
		var self = this;
		var id = this.id = 'label-' + person.generate_id();

		this.origlocalpart = localpart(v);
		this.localpart = html('input', {type: 'text', name: 'localpart', value: this.origlocalpart, placeholder: "New name…", 'class': 'localpart', title: "The part before the @ sign of an e-mail address with which this person must be reachable"});
		this.$localpart = $(this.localpart);
		setInputColor(this.$localpart, this.origlocalpart);

		this.domain = html('select', {name: 'domain', 'class': 'domains', title: "The domain name of an e-mail address with which this person must be reachable"});
		this.$domain = $(this.domain);
		sortedEach(domains_by_name, function(i, name, domain) {
			self.$domain.append(html('option', {value: name}, domainDisplayName(domain)));
		});
		this.origdomain = domainpart(v);
		this.$domain.val(this.origdomain);
		setInputColor(this.$domain, this.origdomain);
		onChange(this.$domain, function() {
			setInputColor2(self.$localpart, self.$domain,
				self.origlocalpart, self.origdomain,
				self.goodlocalpart, self.gooddomain,
				self.badlocalpart, self.baddomain);
		});

		this.clear = html('span', {'class': 'clear-localpart'}, ['strong', '×']);
		this.$clear = $(this.clear);
		this.feedback = html('span', {'class': 'negative-feedback'});
		this.$feedback = $(this.feedback);
		this.div = html('div', this.clear, this.localpart, "@", this.domain, this.feedback);
		this.$div = $(this.div);

		this.person = person;
		var labels_by_id = person.labels_by_id;
		labels_by_id[id] = this;

		this.$clear.click(function() {
			if(self.$localpart.val() != '')
				self.remove();
		});

		onChange(this.$localpart, function() {
			setInputColor2(self.$localpart, self.$domain,
				self.origlocalpart, self.origdomain,
				self.goodlocalpart, self.gooddomain,
				self.badlocalpart, self.baddomain);
			if(self.$localpart.val() == '') {
				for(var k in labels_by_id) {
					var d = labels_by_id[k];
					if(d.id != id && d.$localpart.val() == '')
						d.remove();
				}
			} else {
				var have_empty = false;
				for(var k in labels_by_id) {
					var d = labels_by_id[k];
					if(d.id != id && d.$localpart.val() == '') {
						have_empty = true;
						break;
					}
				}
				if(!have_empty)
					person.addExpandedLabel('@' + self.$domain.val());
			}
		});
	}

	ExpandedLabel.prototype.remove = function() {
		var div = this.div;
		this.$div.slideUp('fast', function(){div.parentNode.removeChild(div)});
		delete this.person.labels_by_id[this.id];
	}

	ExpandedLabel.prototype.goodlocalpart = null;
	ExpandedLabel.prototype.badlocalpart = null;
	ExpandedLabel.prototype.gooddomain = null;
	ExpandedLabel.prototype.baddomain = null;

	function PersonWidget(person) {
		var self = this;

		this.compacted_labels = html('div', {'class': 'clickable'});
		this.$compacted_labels = $(this.compacted_labels);

		this.mailbox_address = html('span');
		this.$mailbox_address = $(this.mailbox_address);

		this.compacted_mailbox = html('p', {'class': 'summary clickable', title: "The mailbox in which e-mail for this person will be delivered"},
			['span', {'class': 'userTypeImage external'}],
			this.mailbox_address
		);
		this.$compacted_mailbox = $(this.compacted_mailbox);

		this.compacted_disabled = html('p', {'class': 'summary clickable', title: disabled_message}, "❌ Disabled");
		this.$compacted_disabled = $(this.compacted_disabled);

		/* Icons for the "expand" and "collapse" actions. */
		this.compacted_img = html('div',
			['img', {src: 'static/expand.png', alt: 'show', 'class': 'showimg'}]);
		this.$compacted_img = $(this.compacted_img);

		this.img_container = html('div', {'class': 'foldimg'}, this.compacted_img);
		this.$img_container = $(this.img_container);

		this.$img_container.click(function(){ self.toggle() });
		this.$compacted_disabled.click(function(){ self.show() });
		this.$compacted_mailbox.click(function(){ self.show() });
		this.$compacted_labels.click(function(){ self.show() });

		this.labels_container = html('td', {'class': 'column from', rowspan: 2}, this.compacted_labels);
		this.$labels_container = $(this.labels_container);

		this.mailbox_container = html('div', this.compacted_mailbox);
		this.$mailbox_container = $(this.mailbox_container);

		this.disabled_container = html('div', this.compacted_disabled);
		this.$disabled_container = $(this.disabled_container);

		this.btn_container = html('td', {'class': 'column right', rowspan: 2});
		this.$btn_container = $(this.btn_container);

		this.div = html('div', {'class': 'entry'},
			['form', {'class': 'editPerson', action: 'javascript:'},
				['table', {'class': 'layout'},
					['tr',
						['td', {'class': 'column left'},
							['span', {'class': 'userTypeImage person'}]
						],
						this.labels_container,
						['td', {'class': 'column to', rowspan: 2},
							this.mailbox_container,
							this.disabled_container,
						],
						this.btn_container,
					],
					['tr',
						['td', {'class': 'column left', style: 'vertical-align: bottom'},
							this.img_container
						]
					]
				]
			]
		);

		this.setPerson_lazy(person);
	}

	PersonWidget.prototype.jit = function() {
		this.jit = function(){};

		var self = this;
		var person = self.person;

		var next_id = 0;
		this.generate_id = function() { return next_id++ };

		this.labels_by_id = {};

		this.expanded_img = html('div', ['img', {src: 'static/collapse.png', alt: 'hide', 'class': 'hideimg'}]);
		this.$expanded_img = $(this.expanded_img);
		this.$expanded_img.hide();
		this.$img_container.append(this.expanded_img);

		this.expanded_labels = html('div', ['div']);
		this.$expanded_labels = $(this.expanded_labels);
		this.$expanded_labels.hide();
		this.$labels_container.append(this.expanded_labels);

		this.feedback = html('span', {'class': 'negative-feedback'});
		this.$feedback = $(this.feedback);

		this.mailbox = html('input', {placeholder: "Mailbox location…", name: 'mailbox', title: "The mailbox in which e-mail for this person will be delivered"});
		this.$mailbox = $(this.mailbox);
		this.expanded_mailbox = html('div', {'class': 'expanded'}, ['div', this.mailbox], ['div', this.feedback]);
		this.$expanded_mailbox = $(this.expanded_mailbox);
		this.$expanded_mailbox.hide();
		this.$mailbox_container.append(this.expanded_mailbox);

		this.expanded_disabled = html('div', {'class': 'expanded'},
			['div', ['p', disabled_message]],
			['div', this.feedback],
		);
		this.$expanded_disabled = $(this.expanded_disabled);
		this.$expanded_disabled.hide();
		this.$disabled_container.append(this.expanded_disabled);

		var submit_btn = html('button', {type: 'button', 'class': 'saveButton', name: 'savePerson', title: "Store your changes"}, ['strong', "Save"]);
		var reset_btn = html('button', {type: 'button', 'class': 'resetButton', name: 'resetPerson', title: "Restore to last saved values"}, "Reset");

		this.expanded_btn = html('div', {'class': 'expanded'}, reset_btn, submit_btn);
		this.$expanded_btn = $(this.expanded_btn);
		this.$expanded_btn.hide();
		this.$btn_container.append(this.expanded_btn);

		onChange(this.$mailbox, function() {
			setInputColor(self.$mailbox, person.mailbox, self.goodmailbox, self.badmailbox);
		});

		$(reset_btn).click(function() {
			if(!confirm("Undo unsaved changes?"))
				return;
			self.setPerson(self.person);
		});

		$(submit_btn).click(function() {
			var person = self.person;
			var labels = [];
			var addresses = [];
			var postdata = {
				labels: addresses,
				mailbox: person.mailbox == null ? null : self.$mailbox.val(),
			};
			var labels_by_id = self.labels_by_id;
			for(var k in labels_by_id) {
				var n = labels_by_id[k];
				labels.push(n);
				var lp = n.$localpart.val();
				addresses.push(lp + '@' + n.$domain.val());
			}
			function success(data) {
				var notes = data.notes;
				var note = notes.update;
				if(note[0] == 'ok') {
					person = data.person;
					self.setPerson(person);
					self.feedback.className = 'positive-feedback';
					self.$feedback.text(feedback_text(note[1]));
					self.hide();
				} else {
					self.feedback.className = 'negative-feedback';
					self.$feedback.text(note[1] === undefined ? '' : feedback_text(note[1]));

					var labelnotes = notes.labels;
					var len = labelnotes.length;
					for(var i = 0; i < len; i++) {
						note = labelnotes[i];
						var l = labels[i];
						if(note[0] == 'ok') {
							var lp = localpart(note[2]);
							var dp = domainpart(note[2]);
							l.goodlocalpart = lp;
							l.$localpart.val(lp);
							l.gooddomain = dp;
							l.$domain.val(dp);
							l.feedback.className = 'positive-feedback';
							l.$feedback.text('');
						} else {
							var lp = localpart(addresses[i]);
							var dp = domainpart(addresses[i]);
							l.badlocalpart = localpart(addresses[i]);
							l.baddomain = domain_implicated[note[1]]
								? domainpart(addresses[i])
								: undefined;
							l.feedback.className = 'negative-feedback';
							l.$feedback.text(feedback_text(note[1]));
						}
						setInputColor2(l.$localpart, l.$domain,
							l.origlocalpart, l.origdomain,
							l.goodlocalpart, l.gooddomain,
							l.badlocalpart, l.baddomain);
					}

					note = notes.mailbox;
					if(note[0] == 'ok') {
						self.goodmailbox = note[2];
						self.$mailbox.val(note[2]);
					} else {
						self.badmailbox = postdata.mailbox;
						self.$feedback.text(feedback_text(note[1]));
					}
					setInputColor(self.$mailbox, person.mailbox, self.goodmailbox, self.badmailbox);
				}
			}
			function failed(jqXHR, textStatus, errorThrown) {
				if(jqXHR.getResponseHeader('Content-Type') === 'application/json')
					success($.parseJSON(jqXHR.responseText));
			}
			var url = 'persons/' + person.anr + qnonce();
			$.ajax({
				url: url,
				data: JSON.stringify(postdata),
				contentType: 'application/json',
				dataType: 'json',
				success: success,
				error: failed,
				type: 'PUT'
			});
		});

		this.setPerson(person);
	}

	PersonWidget.prototype.show = function() {
		this.jit();
		this.$compacted_labels.slideUp('fast');
		this.$expanded_labels.slideDown('fast');
		this.$compacted_mailbox.slideUp('fast');
		this.$expanded_mailbox.slideDown('fast');
		this.$expanded_disabled.slideDown('fast');
		this.$expanded_btn.slideDown('fast');
		this.$compacted_img.hide();
		this.$expanded_img.show();
	}

	PersonWidget.prototype.hide = function() {
		this.jit();
		this.$compacted_labels.slideDown('fast');
		this.$expanded_labels.slideUp('fast');
		this.$compacted_mailbox.slideDown('fast');
		this.$expanded_mailbox.slideUp('fast');
		this.$expanded_disabled.slideUp('fast');
		this.$expanded_btn.slideUp('fast');
		this.$compacted_img.show();
		this.$expanded_img.hide();
	}

	PersonWidget.prototype.toggle = function() {
		this.jit();
		this.$compacted_labels.slideToggle('fast');
		this.$expanded_labels.slideToggle('fast');
		this.$compacted_mailbox.slideToggle('fast');
		this.$expanded_mailbox.slideToggle('fast');
		this.$expanded_disabled.slideToggle('fast');
		this.$expanded_btn.slideToggle('fast');
		this.$compacted_img.toggle();
		this.$expanded_img.toggle();
	}

	PersonWidget.prototype.addExpandedLabel = function(v) {
		this.expanded_labels.appendChild(new ExpandedLabel(this, v).div);
	}

	PersonWidget.prototype.setPerson_lazy = function(person) {
		this.person = person;

		this.$compacted_labels.empty();
		var compacted_labels = this.compacted_labels;
		$.each(person.labels, function(i, n) {
			var title = i
				? "A secondary e-mail address with which this person is reachable"
				: "The primary e-mail address with which this person is reachable";
			compacted_labels.appendChild(html('div', {'title': title}, i ? n : ['strong', n]));
		});

		if(person.mailbox == null) {
			this.$mailbox_container.hide();
			this.$disabled_container.show();
		} else {
			this.$mailbox_address.text(person.mailbox);
			this.$mailbox_container.show();
			this.$disabled_container.hide();
		}
	}

	PersonWidget.prototype.setPerson = function(person) {
		this.setPerson_lazy(person);

		this.labels_by_id = {};
		$(this.expanded_labels).empty();
		var self = this;
		$.each(person.labels, function(i, n) {
			self.addExpandedLabel(n);
		});
		self.addExpandedLabel('@' + domainpart(person.labels[0]));

		this.$mailbox.val(person.mailbox);
		this.goodmailbox = undefined;
		this.badmailbox = undefined;
		setInputColor(this.$mailbox, person.mailbox);
	}

	function ExpandedDestination(alias, v) {
		var id = this.id = 'dst-' + alias.generate_id();
		var input = this.input = html('input', {type: 'text', name: 'destination', value: v, placeholder: "New destination…", title: "An address to which e-mail for this alias will be forwarded"});
		var $input = this.$input = $(input);
		var clear = this.clear = html('span', {'class': 'clear-destination'}, ['strong', '×']);
		var $clear = this.$clear = $(clear);
		var feedback = this.feedback = html('span', {'class': 'negative-feedback'});
		var $feedback = this.$feedback = $(feedback);
		var div = this.div = html('div', clear, input, feedback);
		var $div = this.$div = $(div);

		this.orig = v;
		this.alias = alias;
		var destinations_by_id = alias.destinations_by_id;
		destinations_by_id[id] = this;

		var self = this;

		$clear.click(function() {
			if($input.val() != '')
				self.remove();
		});

		onChange($input, function() {
			setInputColor($input, self.orig, self.good, self.bad);
			if($input.val() == '') {
				for(var k in destinations_by_id) {
					var d = destinations_by_id[k];
					if(d.id != id && d.$input.val() == '')
						d.remove();
				}
			} else {
				var have_empty = false;
				for(var k in destinations_by_id) {
					var d = destinations_by_id[k];
					if(d.id != id && d.$input.val() == '') {
						have_empty = true;
						break;
					}
				}
				if(!have_empty)
					alias.addExpandedDestination('');
			}
		});
	}

	ExpandedDestination.prototype.remove = function() {
		var div = this.div;
		this.$div.slideUp('fast', function(){div.parentNode.removeChild(div)});
		delete this.alias.destinations_by_id[this.id];
	}

	ExpandedDestination.prototype.good = null;
	ExpandedDestination.prototype.bad = null;

	function AliasWidget(alias) {
		var self = this;

		if(alias === undefined)
			alias = {address: '@uvt.nl', destinations: {}};

		/* in MSIE is 'class' een keyword, altijd kwoten dus */
		this.compacted_dst = html('p', {'class': 'summary clickable'});
		this.$compacted_dst = $(this.compacted_dst);

		/* Icons for the "expand" and "collapse" actions. */
		this.compacted_img = html('div',
			['img', {src: 'static/expand.png', alt: 'show', 'class': 'showimg'}]);
		this.$compacted_img = $(this.compacted_img);

		this.img_container = html('div', {'class': 'foldimg'}, this.compacted_img);
		this.$img_container = $(this.img_container);

		var delete_btn = html('button', {type: 'button', name: 'delAlias', title: "Remove this alias permanently"}, "Delete");

		this.compacted_btn = html('div', {'class': 'compacted'}, delete_btn);
		this.$compacted_btn = $(this.compacted_btn);

		this.compacted_addresstext = html('strong');
		this.$compacted_addresstext = $(this.compacted_addresstext);
		this.compacted_address = html('div', {'class': 'clickable'}, this.compacted_addresstext);
		this.$compacted_address = $(this.compacted_address);

		$(delete_btn).click(function() {
			self.jit();
			if(self.alias.address === undefined)
				return;
			if(!confirm("Are you sure you want to delete the alias " + full(self.alias) + "?"))
				return;
			var url = 'aliases/'+full(self.alias) + qnonce();
			$.ajax({
				url: url,
				dataType: 'json',
				success: function(data) {
					var note = data.note;
					if(note[0] == 'ok') {
						$(self.div).slideUp('fast');
					} else {
						self.feedback.className = 'negative-feedback';
						self.$feedback.text(feedback_text(note[1]));
						setTimeout(function() { self.show() }, 0);
					}
				},
				type: 'DELETE'
			});
		});

		this.$img_container.click(function(){ self.toggle() });
		this.$compacted_dst.click(function(){ self.show() });
		this.$compacted_address.click(function(){ self.show() });

		this.address_container = html('div', this.compacted_address);
		this.$address_container = $(this.address_container);

		this.dst_container = html('td', {'class': 'column to', rowspan: 2}, this.compacted_dst);
		this.$dst_container = $(this.dst_container);

		this.btn_container = html('td', {'class': 'column right', rowspan: 2}, this.compacted_btn);
		this.$btn_container = $(this.btn_container);

		this.div = html('div', {'class': 'entry'},
			['form', {'class': 'editAlias', action: 'javascript:'},
				['table', {'class': 'layout'},
					['tr',
						['td', {'class': 'column left'},
							['span', {'class': 'userTypeImage alias'}]
						],
						['td', {'class': 'column from', rowspan: 2}, this.address_container],
						this.dst_container, this.btn_container
					],
					['tr',
						['td', {'class': 'column left', style: 'vertical-align: bottom'},
							this.img_container
						]
					]
				]
			]
		);
		this.$div = $(this.div);

		this.setAlias_lazy(alias);
	}

	AliasWidget.prototype.jit = function() {
		this.jit = function(){};

		var self = this;
		var alias = self.alias;

		var next_id = 0;
		this.generate_id = function() { return next_id++ };

		this.expanded_dst = html('div', {'class': 'expanded'});
		this.$expanded_dst = $(this.expanded_dst);
		this.$dst_container.append(this.expanded_dst);

		this.destinations_by_id = {};

		this.expanded_img = html('div', ['img', {src: 'static/collapse.png', alt: 'hide', 'class': 'hideimg'}]);
		this.$expanded_img = $(this.expanded_img);
		self.$img_container.append(this.expanded_img);

		this.localpart = html('input', {type: 'text', name: 'localpart', 'class': 'localpart', placeholder: "Name…", maxlength: 64, title: "The part before the @ sign of this alias"});
		this.$localpart = $(this.localpart);

		function colorize_address() {
			var address = self.alias.address;
			setInputColor2(self.$localpart, self.$domain,
				localpart(address), domainpart(address),
				self.goodlocalpart, self.gooddomain,
				self.badlocalpart, self.baddomain);
		}

		onChange(this.$localpart, colorize_address);

		this.domain = html('select', {name: 'domain', 'class': 'domains', title: "The domain name of this alias"});
		this.$domain = $(this.domain);
		sortedEach(domains_by_name, function(i, name, domain) {
			self.$domain.append(html('option', {value: name}, domainDisplayName(domain)));
		});

		onChange(this.$domain, colorize_address);

		var submit_btn = html('button', {type: 'button', 'class': 'saveButton', name: 'saveAlias', title: "Store your changes"}, ['strong', "Save"]);
		var reset_btn = html('button', {type: 'button', 'class': 'resetButton', name: 'resetAlias', title: "Restore to last saved values"}, "Reset");

		this.expanded_btn = html('div', {'class': 'expanded'}, reset_btn, submit_btn);
		this.$expanded_btn = $(this.expanded_btn);
		this.$btn_container.append(this.expanded_btn);

		this.feedback = html('span', {'class': 'negative-feedback'});
		this.$feedback = $(this.feedback);

		this.addressbook = html('select', {name: 'addressbook', 'class': 'addressbook', title: "Whether to show this alias in the LDAP address book"},
			['option', {value: '', disabled: 'disabled', selected: 'selected'}, "Address book?"],
			['option', {value: 'true'}, "Show in address book"],
			['option', {value: 'false'}, "Do not show in address book"]
		);
		this.$addressbook = $(this.addressbook);

		onChange(this.$addressbook, function() {setInputColor(self.$addressbook, bool2text(self.alias.addressbook), self.goodaddressbook, self.badaddressbook)});

		this.expanded_address = html('div', ['div', this.localpart, '@', this.domain], ['div', this.addressbook], ['p', this.feedback]);
		this.$expanded_address = $(this.expanded_address);
		this.$address_container.append(this.expanded_address);

		$(reset_btn).click(function() {
			if(!confirm("Undo unsaved changes?"))
				return;
			self.setAlias(self.alias);
		});

		$(submit_btn).click(function() {
			var addresses = [];
			var destinations = [];
			var ab = self.$addressbook.val();
			var postdata = {
				address: self.$localpart.val() + '@' + self.$domain.val(),
				destinations: addresses,
				addressbook: text2bool(ab, null)
			};
			var destinations_by_id = self.destinations_by_id;
			for(var k in destinations_by_id) {
				var d = destinations_by_id[k];
				destinations.push(d);
				addresses.push(d.$input.val());
			}
			function success(data) {
				var notes = data.notes;
				var note = notes.update;
				if(note[0] == 'ok') {
					if(localpart(self.alias.address) == '') {
						var widget = new AliasWidget({address: '@' + domainpart(data.alias.address), destinations: []});
						widget.$div.hide();
						$kikiAlias.append(widget.div);
						widget.$div.slideDown('fast');
					}
					self.setAlias(data.alias);
					self.feedback.className = 'positive-feedback';
					self.$feedback.text(feedback_text(note[1]));
					self.hide();
				} else {
					self.feedback.className = 'negative-feedback';
					self.$feedback.text(note[1] === undefined ? '' : feedback_text(note[1]));

					var dnotes = notes.destinations;
					var len = destinations.length;
					for(var i = 0; i < len; i++) {
						note = dnotes[i];
						var d = destinations[i];
						if(note[0] == 'ok') {
							d.good = note[2];
							d.$input.val(note[2]);
							destinations[i].$feedback.text('');
						} else {
							d.bad = addresses[i];
							d.$feedback.text(feedback_text(note[1]));
						}
						setInputColor(d.$input, d.orig, d.good, d.bad);
					}

					note = notes.address;
					if(note[0] == 'ok') {
						self.goodlocalpart = localpart(note[2]);
						self.$localpart.val(self.goodlocalpart);
						self.gooddomain = domainpart(note[2]);
						self.$domain.val(self.gooddomain);
					} else {
						self.badlocalpart = localpart(postdata.address);
						self.baddomain = domain_implicated[note[1]]
							? domainpart(postdata.address)
							: undefined;
						self.$feedback.text(feedback_text(note[1]));
					}
					colorize_address();

					note = notes.addressbook;
					if(note[0] == 'ok') {
						var ab = bool2text(note[2]);
						self.$addressbook.val(ab);
						self.goodaddressbook = ab;
					} else {
						self.badaddressbook = '';
						self.$feedback.text(feedback_text(note[1]));
					}
					setInputColor(self.$addressbook, bool2text(self.alias.addressbook), self.goodaddressbook, self.badaddressbook);
				}
			}
			var url = localpart(self.alias.address) == ''
				? 'aliases' + qnonce()
				: 'aliases/' + full(self.alias) + qnonce();
			$.ajax({
				url: url,
				data: JSON.stringify(postdata),
				contentType: 'application/json',
				dataType: 'json',
				success: success,
				type: 'POST'
			});
		});

		this.$expanded_dst.hide();
		this.$expanded_address.hide();
		this.$expanded_btn.hide();
		this.$expanded_img.hide();

		this.setAlias(alias);
	}

	AliasWidget.prototype.show = function() {
		this.jit();
		this.$compacted_dst.slideUp('fast');
		this.$expanded_dst.slideDown('fast');
		this.$compacted_address.slideUp('fast');
		this.$expanded_address.slideDown('fast');
		this.$expanded_btn.slideDown('fast');
		this.$compacted_img.hide();
		this.$expanded_img.show();
	}

	AliasWidget.prototype.hide = function() {
		this.jit();
		this.$compacted_dst.slideDown('fast');
		this.$expanded_dst.slideUp('fast');
		this.$compacted_address.slideDown('fast');
		this.$expanded_address.slideUp('fast');
		this.$expanded_btn.slideUp('fast');
		this.$compacted_img.show();
		this.$expanded_img.hide();
	}

	AliasWidget.prototype.toggle = function() {
		this.jit();
		this.$compacted_dst.slideToggle('fast');
		this.$expanded_dst.slideToggle('fast');
		this.$compacted_address.slideToggle('fast');
		this.$expanded_address.slideToggle('fast');
		this.$expanded_btn.slideToggle('fast');
		this.$compacted_img.toggle();
		this.$expanded_img.toggle();
	}

	AliasWidget.prototype.addExpandedDestination = function(v) {
		this.expanded_dst.appendChild(new ExpandedDestination(this, v).div);
	}

	AliasWidget.prototype.setAlias_lazy = function(alias) {
		this.alias = alias;

		if(localpart(alias.address) == '') {
			this.$compacted_addresstext.text("Add a new alias…");
			this.compacted_address.title = "Click to create a new alias";
			this.$compacted_btn.hide();
		} else {
			this.$compacted_addresstext.text(alias.address);
			this.$compacted_btn.slideDown('fast');
			this.compacted_address.title = "Click to edit this alias";
		}

		this.$compacted_dst.empty();
		var compacted_dst = this.compacted_dst;
		sortedTypes(alias.destinations, function(i, t, d) {
			$.each(d, function(j, e) {
				var title = "An address to which e-mail for this alias is forwarded";
				switch(t) {
					case 'person':
						title = "This person receives e-mail sent to this alias";
						break;
					case 'alias':
						title = "E-mail for " + alias.address + " is forwarded to the recipients of " + e + " as well";
						break;
					case 'external':
						title = "This external address receives e-mail sent to this alias";
						break;
				}
				compacted_dst.appendChild(html('span', {style: 'display: inline-block', 'title': title},
					['span', {'class': 'userTypeImage ' + t}],
					e + '\xA0\xA0'
				));
			});
		});
	}

	AliasWidget.prototype.setAlias = function(alias) {
		this.setAlias_lazy(alias);

		this.$localpart.val(localpart(alias.address));

		this.goodlocalpart = undefined;
		this.badlocalpart = undefined;
		setInputColor(this.$localpart, localpart(alias.address));

		this.$domain.val(domainpart(alias.address));
		this.gooddomain = undefined;
		this.baddomain = undefined;
		setInputColor(this.$domain, domainpart(alias.address));

		this.goodaddressbook = undefined;
		this.badaddressbook = undefined;
		if(alias.addressbook === undefined) {
			this.$addressbook.val('');
			setInputColor(this.$addressbook);
		} else {
			var ab = bool2text(alias.addressbook);
			this.$addressbook.val(ab);
			setInputColor(this.$addressbook, ab);
		}

		this.destinations_by_id = {};
		$(this.expanded_dst).empty();
		var self = this;
		sortedTypes(alias.destinations, function(i, t, d) {
			$.each(d, function(j, e) {
				self.addExpandedDestination(e);
			});
		});
		self.addExpandedDestination('');
	}

	function searchResult(data) {
		$kikiAlias.empty();

		var results = data.results;
		for(var i = 0; i < results.length; i++) {
			var alias = results[i];
			var widget = alias.anr
				? new PersonWidget(alias)
				: new AliasWidget(alias);
			$kikiAlias.append(widget.div);
		}
		if(!results.length && data.query !== '') {
			$kikiAlias.append(html('p', {'class': 'search-feedback'},
				['span', {'class': 'negative-feedback search-feedback'},
					"No matching aliases found"]));
		}
		var create = new AliasWidget();
		$kikiAlias.append(create.div);
	}

	function zoek() {
		var q = $searchTextInput.val();
		window.location.hash = '#' + encodeURIComponent(q);
		$.ajax({
			url: 'search',
			data: { q: q },
			success: searchResult,
			dataType: 'json',
			type: 'GET'
		});
	}

	function getNonce() {
		$.ajax({
			url: 'nonce',
			success: function(data) { nonce = data.nonce },
			error: function(data) { if(confirm("Your session seems to have expired. You need to reload the page to be able to continue, but doing so will undo any pending changes you have made. Reload now?")) location.reload() },
			dataType: 'json',
			type: 'GET'
		});
	}

	getNonce();
	setInterval(getNonce, 1800000);

	function domeinenGeladen(data) {
		domains_by_name = {};
		var domains = data.domains;
		for(var i = 0; i < domains.length; i++) {
			var names = domains[i];
			domains_by_name[names[0]] = names;
		}

		var q = window.location.hash;
		if(q)
			q = decodeURIComponent(q.substr(1));
		if(q) {
			$searchTextInput.val(q);
			zoek();
		} else {
			var widget = new AliasWidget();
			$kikiAlias.append(widget.div);
		}
	}

	$.ajax({
		url: 'domains',
		success: domeinenGeladen,
		dataType: 'json',
		type: 'GET'
	});

	$(window).bind('hashchange', function() {
		var q = window.location.hash;
		if(q)
			q = decodeURIComponent(q.substr(1));
		if(q == $searchTextInput.val())
			return;
		if(q) {
			$searchTextInput.val(q);
			zoek();
		} else {
			var widget = new AliasWidget();
			$kikiAlias.append(widget.div);
		}
	});

	$searchForm.submit(zoek);
});
