# $Id: Config.pm 37652 2012-08-27 15:36:20Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/Config.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::Config;

use Xyzzy -self;

field languages => [];

sub set_languages {
	$self->languages([split(' ', $_[0])]);
}

field notification_sender => sub { die "No NotificationSender configured\n" };

sub set_notificationsender {
	my $addr = shift;
	die "couldn't parse value\n" unless defined $addr;
	my ($x, $y) = Email::Address->parse($addr);
	die "couldn't parse value\n" unless defined $x;
	die "couldn't parse value\n" if defined $y;
	die "couldn't parse value\n" unless $x->original eq $addr;

	$self->notification_sender($x->format);
}

field notification_recipients => [];

sub set_notificationrecipients {
	my @addrs;

	my $oneliner = shift;
	if(defined $oneliner) {
		push @addrs, Email::Address->parse($oneliner);
	}

	foreach my $addr (@_) {
		my ($x, $y) = Email::Address->parse($addr);
		die "couldn't parse value\n" unless defined $x;
		die "couldn't parse value\n" if defined $y;
		die "couldn't parse value\n" unless $x->original eq $addr;
		push @addrs, $x;
	}

	push @{$self->notification_recipients}, map { $_->format } @addrs;
}

*set_notificationrecipient = *set_notificationrecipients;

field activate_command => undef;

*set_activatecommand = *activate_command;
