use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::ACL;

use Xyzzy::Crypto;
use UvT::Kiki::ACL::Request;
use UvT::Kiki::ACL::Document;

use Xyzzy::Handler -self;

field crypto => sub { new Xyzzy::Crypto(cfg => shift->cfg) };

field allowed_users => sub { shift->cfg->allowed_users };
field allowed_robots => sub { shift->cfg->allowed_robots };

sub handle {
	my $req = new UvT::Kiki::ACL::Request(ctx => shift, cfg => $self);
	die UvT::Kiki::ACL::Document(req => $req)->new->response
 		unless $req->authorized;
	my $res = super($req, @_);
	$res->setcookie($req->session) unless $req->cur_session;
	return $res;
}
