use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::ACL::Config;

use Xyzzy -self;

use Xyzzy::Util qw(parse_time);

field request_timeout => 3600;

sub set_requesttimeout { $self->request_timeout(parse_time(shift)) }

field allowed_users => {};

sub set_allowedusers {
	my ($immediate, @lines) = @_;
	my $users = $self->allowed_users;
	@$users{split(' ', $immediate)} = () if defined $immediate;
	foreach my $line (@lines) {
		@$users{split(' ', $line)} = ();
	}
}

*set_alloweduser = *set_allowedusers;
*set_allowusers = *set_allowedusers;
*set_allowuser = *set_allowedusers;

field allowed_robots => {};

sub set_allowedrobots {
	my ($immediate, @lines) = @_;
	my $robots = $self->allowed_robots;
	@$robots{split(' ', $immediate)} = () if defined $immediate;
	foreach my $line (@lines) {
		@$robots{split(' ', $line)} = ();
	}
}

*set_allowedrobot = *set_allowedrobots;
*set_allowrobots = *set_allowedrobots;
*set_allowrobot = *set_allowedrobots;
