# $Id: Request.pm 47242 2017-12-17 17:51:34Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Person/Put/Request.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::WS::Person::Put::Request;

use JSON;

use UvT::Kiki::WS::Person::Request -self;

field notes => {labels => []};

field request_data => sub {
	my $self = shift;
	my $type = $self->content_type;
	die "Unsupported request content type '$type' (expected application/json)\n"
		if $type ne 'application/json';
	return decode_json($self->request_body->bodyhandle->as_string);
};

field new_person => sub {
	my $self = shift;
	my $anr = $self->anr;
	my $person = super || $self->db->new_person($anr);
	my $notes = $self->notes;

	if($self->nonce) {
		my $db = $self->db;
		my $data = $self->request_data;
		my $is_robot = $self->is_robot;

		if($person->type eq 'alias') {
			$notes->{update} = [error => 'alias'];
			return $person;
		}

		unless($person->original) {
			if($anr < 100000 || $anr > 999999) {
				$notes->{update} = [error => 'invalid-anr'];
				return $person;
			}
			unless($is_robot) {
				$notes->{update} = [error => 'no-robot'];
				return $person;
			}
		}

		my @labels = map { trim($_) } @{$data->{labels}};

		$notes->{labels} = $person->update_labels(\@labels, !$is_robot);
		$notes->{mailbox} = $person->update_mailbox(trim($data->{mailbox}));

		if(grep { $_->[0] eq 'error' } @{$notes->{labels}}, $notes->{mailbox}) {
			$notes->{update} = ['error'];
		} else {
			my $what = $is_robot ? "Robot" : "User";
			my $who = $self->login;
			my $new = $person->toString;
			my $full = $person->full;
			my $anr = sprintf('%06d', $anr);
			if(my $original = $person->original) {
				my $old = $original->toString;
				warn "$what $who updated person $anr:\n\told: $old\n\tnew: $new\n";
				$self->mailtje("[kiki] $who updated $full ($anr)", $person->diff);
			} else {
				warn "$what $who created person $anr:\n\tnew: $new\n";
				$self->mailtje("[kiki] $who created $full ($anr)", $person->diff);
			}

			$person->store;
			$self->activate;
			$notes->{update} = [ok => 'stored'];
		}
	} else {
		$notes->{update} = [error => 'session'];
	}

	return $person;
};
