#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;
use MIME::Base64;

BEGIN { use_ok('Aselect::Crypto') or BAIL_OUT('need Aselect::Crypto to run') }

my @seq;
for(my $i = 1; $i < 191; $i++) {
	push @seq, "\0"x$i;
	push @seq, "\xff"x$i;
	for(my $j = 0; $j < 8; $j++) {
		push @seq, chr(1<<$j).("\xff"x($i - 1));
	}
}

foreach my $raw (
	'',
	@seq,
	(map { decode_base64($_) }
		'4AQlP4lP0xGaDAMF6CwzAQ==',
		'ZFmrGQU/LCeX0zo2wlw8KFJlTqJDqSumyS9OAF8bhcUABMmpzyV4iGvHJDdlKwZ2t5peLnt8lGd1MTI1MDgwOA==',
		'AFmrGQU/LCeX0zo2wlw8KFJlTqJDqSumyS9OAF8bhcUABMmpzyV4iGvHJDdlKwZ2t5peLnt8lGd1MTI1MDgwOA==',
	),
) {
	my $enc = Aselect::Crypto::encode_base($raw, 63);
	my $dec = Aselect::Crypto::decode_base($enc, 63);
#	warn "\nenc: $enc\n";
#	warn "raw length: ".length($raw)."\n";
#	warn "dec length: ".length($dec)."\n";
	is(encode_base64($dec, ''), encode_base64($raw, ''), "base-63 encode+decode for $enc");
}

done_testing();
