use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::LDAP::Config;

use Net::LDAP::Filter;

use Xyzzy -self;

field ldap_server => 'ldap://localhost';
field ldap_base => sub { die "no LDAPBase configured\n" };
field ldap_filter => undef;
field ldap_attribute => 'uid';
field ldap_username => undef;
field ldap_password => sub { die "no LDAPPassword configured\n" if shift->ldap_username };
field ldap_secure => 1;
field ldap_capath => undef;
field ldap_cafile => undef;

*set_ldapserver = *ldap_server;
*set_ldapbase = *ldap_base;
*set_ldapattribute = *ldap_attribute;
*set_ldapusername = *ldap_username;
*set_ldappassword = *ldap_password;

sub set_ldapfilter {
	my $filter = shift;

	my $compiled = eval { new Net::LDAP::Filter($filter) };
	die "error parsing LDAP filter '$filter': $@" if $@;
	die "error parsing LDAP filter '$filter'\n" unless $compiled;

	$self->ldap_filter($compiled);
}

sub set_ldapcafile {
	my $value = shift;
	die "'$value' not accessible\n"
		unless -r $value;
	die "'$value' not a file\n"
		unless -f _;
	$self->ldap_cafile($value);
}

sub set_ldapsecure {
	$self->ldap_secure(parse_bool(shift));
}

sub set_ldapcapath {
	my $value = shift;
	die "LDAPCApath '$value' not accessible\n"
		unless -r $value;
	die "LDAPCApath '$value' not a directory\n"
		unless -d _;
	$self->ldap_capath($value);
}
