use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Cookie;

use Xyzzy::Util qw(uri_escape_auto);
use Xyzzy::Header;

use Clarity -self;

field name;
field value;
field parameters => {};

{
my %boolean = (secure => undef, discard => undef, httponly => undef);
my %case = (httponly => 'HttpOnly');

sub headerize() {
	my @headerized;

	while(@_) {
		my $key = lc(shift);
		my $val = shift;
		if(exists $boolean{$key}) {
			next unless $val;
			undef $val;
		}
		$key =~ s{([a-z]+)}{$case{$1} // ucfirst($1)}eg;
		push @headerized, $key, $val;
	}

	return wantarray ? @headerized : \@headerized;
}

sub setparameters {
	my $parameters = $self->parameters;
	while(@_) {
		my $key = lc(shift);
		$parameters->{$key} = shift;
	}
}

*setparameter = *setparameters;

sub unsetparameters {
	delete @{$self->parameters}{map { lc } @_};
}

*unsetparameter = *unsetparameters;
}

sub new {
	my $name = shift;
	my $value = shift;

	$self = super(name => $name, value => $value);
	$self->setparameter(Version => 1, @_);
	return $self;
}

{
my @months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
my @days = qw(Sun Mon Tue Wed Thu Fri Sat);

sub expire {
	my $time = shift;

	if(defined $time) {
		$time = Xyzzy::parse_time($time);
		my $date;
		if($time) {
			my @date = gmtime(time + $time);
			$date = sprintf('%s, %02d-%s-%04d %02d:%02d:%02d GMT',
				$days[$date[6]], $date[3], $months[$date[4]], 1900+$date[5],
				$date[2], $date[1], $date[0]);
		} else {
			$time = 0;
			$date = 'Thu, 01-Jan-1970 00:00:00 GMT';
		}
		$self->setparameters(Expires => $date, 'Max-Age' => $time);
	} else {
		$self->unsetparameters(qw(expires max-age));
	}
}
}

sub as_header {
	my %values;

	return new Xyzzy::Header(
		uri_escape_auto($self->name) => uri_escape_auto($self->value),
		headerize(%{$self->parameters}));
}

sub toString { return $self->as_header->toString };

use overload
	'""' => \&toString,
	fallback => 1;
