use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Static::Config;

use Clarity -self;

field static_stylesheet => undef;
*set_staticstylesheet = *static_stylesheet;

package Xyzzy::Static::Request;

use Xyzzy::Request -self;

sub file {
	return $self->{file} if exists $self->{file};

	my $cfg = $self->cfg;

	my $path = $self->path_components;
	my $file = $cfg->file;
	if($file) {
		die $self->error(404) if @$path;
		$file = $cfg->contentdir . '/' . $file . '.xml'
			unless ord($file) == 47; # /
	} else {
		foreach(@$path) {
			unless(/^[a-z0-9]+([._,-]+[a-z0-9]+)*$/i) {
				my $info = join('/', @$path);
				die $self->error(403, "Bad path: '$info'");
			}
		}
		$path = ['index'] unless @$path;
		$file = join('/', $cfg->contentdir, @$path) . '.xml';
	}

	die $self->error(404) unless -f $file;
	die $self->error(403) unless -r _;

	return $self->{file} = $file;
}

package Xyzzy::Static::Document;

use Xyzzy::Document::XHTML -self;

sub build {
	my $parser = $self->xmlParser;
	my $file = $self->req->file;
	my $xml = $parser->parse_file($file)
		or die "can't parse $file\n";
	$self->xml($xml);
	if(my $sheet = $self->cfg->static_stylesheet) {
		$self->transform($sheet);
	}
}

package Xyzzy::Static;

use Xyzzy::Handler -self;

field file => undef;
field contentdir => sub { shift->cfg->contentdir };
field static_stylesheet => sub { shift->cfg->static_stylesheet };

sub handle {
	my $req = new Xyzzy::Static::Request(ctx => shift, cfg => $self);
	my $doc = new Xyzzy::Static::Document(req => $req);

	return $doc->response;
}
