use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Method::Request;

use Xyzzy::Request -self;

field method => sub { shift->request_method };

package Xyzzy::Method;

use Xyzzy::Handler -self;

use Xyzzy::Fail;

field methods => {};

sub handle {
	my $req = new Xyzzy::Method::Request(cfg => $self, ctx => shift);

	my $method = $req->method;

	my $handler = $self->methods->{$method};
	return $self->handler->handle($req, @_)
		unless $handler;

	return $handler->handle($req, @_);
}
