use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy;

use IO::File;

use Xyzzy::Status;
use Xyzzy::Static;
use Xyzzy::Directory;
use Xyzzy::Document;
use Xyzzy::Util qw(parse_time parse_size parse_bool);

use Clarity -self;
use Xyzzy::Document::Config -mixin;
use Xyzzy::Document::XHTML::Config -mixin;
use Xyzzy::Static::Config -mixin;

our @EXPORT_BASE = qw(parse_time parse_size parse_bool);

sub set_application {
	my $class = $_[0];
	die "Missing argument to Application\n" unless defined $class;
	eval "use $class";
	die $@ if $@;
	bless $self, $class;
	$self->new;
}

field benchmark => undef;

sub set_benchmark {
	$self->benchmark(!!$_[0]);
}

sub handle_configuration_item {
	my ($key, $values, $filename, $lineno) = @_;
	return unless defined $key;
	eval {
		my $lkey = lc "set_$key";
		die "unknown key\n" unless $self->can($lkey);
		$self->$lkey(@$values)
	};
	die "$filename:$lineno: $key: $@" if $@;
}

sub include {
	foreach my $filename (@_) {
		my $fh = new IO::File($filename, '<:utf8')
			or die "Can't open configuration file '$filename': $!\n";;

		my ($ws, $lineno);
		my ($key, @values);

		while(defined(my $line = $fh->getline)) {
			next if ord($line) == 35; #
			$line =~ s/\s+$//;
			if($line eq '') {
				$ws = 1;
				next;
			}
			if($line =~ s/^\s//) {
				unless(defined $key) {
					my $lineno = $fh->input_line_number;
					warn "Line continuation before key at $filename:$lineno\n";
					next;
				}
				if($ws) {
					push @values, '';
					undef $ws;
				}
				push @values, $line;
			} else {
				$self->handle_configuration_item($key, \@values, $filename, $lineno);
				@values = ();
				$lineno = $fh->input_line_number;
				($key, my $val) = split(/\s+/, $line, 2);
				push @values, $val;
				undef $ws;
			}	
		}

		die "Can't read from configuration file '$filename': $!\n"
			unless $fh->eof;

		$self->handle_configuration_item($key, \@values, $filename, $lineno);

		$fh->close;
	}
}

*set_include = *include;

sub error {
	my $status = new Xyzzy::Status(@_);
	return $status->response;
}

sub handler {
	my $static = new Xyzzy::Static(cfg => $self);

	return new Xyzzy::Directory(cfg => $self,
		handler => $static,
		fallback => $static,
	);
}

sub new {
	return $self if ref $self;
	return bless {}, $self;
}
