use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Util;

use Encode;
use URI::Escape;
use Exporter 'import';

our @EXPORT_OK = qw(iso8601 iso8601_date iso8601_strict uri_escape_auto uri_escape_plus uri_unescape_plus htmlentities);
our %EXPORT_TAGS = (all => \@EXPORT_OK);  

sub iso8601 {
	my ($sec, $min, $hour, $mday, $mon, $year) = @_;
	return sprintf('%04d-%02d-%02d %02d:%02d:%02d',
		$year + 1900, $mon + 1, $mday, $hour, $min, $sec)
}

sub iso8601_date {
	my (undef, undef, undef, $mday, $mon, $year) = @_;
	return sprintf('%04d-%02d-%02d',
		$year + 1900, $mon + 1, $mday)
}

sub iso8601_strict {
	my ($sec, $min, $hour, $mday, $mon, $year) = @_;
	return sprintf('%04d-%02d-%02dT%02d:%02d:%02d',
		$year + 1900, $mon + 1, $mday, $hour, $min, $sec)
}

sub uri_escape_auto {
	my $val = shift;
	Encode::_utf8_off($val);
	return uri_escape($val, @_);
}

sub uri_escape_plus {
	my $str = uri_escape_auto(@_);
	$str =~ s/%20/+/g;
	return $str;
}

sub uri_unescape_plus {
	return uri_unescape(map { my $str = $_; $str =~ tr/+/ /; $str } @_);
}

BEGIN {
	my %htmlentities = (
		'"' => '&quot;',
		"'" => '&apos;',
		'<' => '&lt;',
		'>' => '&gt;',
		'&' => '&amp;',
	);

	my $escapes = quotemeta(join('', keys %htmlentities));

	sub htmlentities {
		my $html = shift;

		$html =~ s/([$escapes])/$htmlentities{$1}/ego;
		$html =~ s/([^\t\n -~])/'&#'.ord($1).';'/eg;

		return $html;
	}
}
