#! /usr/bin/perl

# $Id: uvt-email-template.pl 39351 2013-05-03 13:49:34Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/uvt-email-template/bin/uvt-email-template.pl $

use strict;
use warnings FATAL => 'all';
use utf8;

our $PACKAGE //= 'uvt-email-template';
our $pkgdatadir //= our $datadir ? "$datadir/$PACKAGE" : 'share';

use UvT::Email::Template;

my $e = new UvT::Email::Template(htmltemplate => "$pkgdatadir/html.xsl", imagepath => $pkgdatadir);

print $e->format($ARGV[0], Subject => 'testje');

__END__

=pod

=encoding utf8

=head1 NAME

uvt-email-template - Convert an XML formatted message to RFC2822

=head1 SYNOPSIS

 uvt-email-template foo.xml

=head1 AUTHOR

Wessel Dankers <wsl@uvt.nl>

=head1 COPYRIGHT

Copyright © 2013 Tilburg University.

Licensed under the GPLv3 license or (at your option) any later version.
