<?php

require_once 'aselect/client.php';

/**
 * Authentication module which acts as an A-Select client
 * (using an A-Select agent)
 *
 * @author Wessel Dankers, Tilburg University
 */
class sspmod_aselectagent_Auth_Source_ASelectAgent extends SimpleSAML_Auth_Source {
	// A-Select application ID
	private $app_id;

	/**
	 * Constructor for this authentication source.
	 *
	 * @param array $info  Information about this authentication source.
	 * @param array $config  Configuration.
	 */
	public function __construct($info, $config) {
		/* Call the parent constructor first, as required by the interface. */
		parent::__construct($info, $config);

		$cfg = SimpleSAML_Configuration::loadFromArray($config,
			'Authentication source ' . var_export($this->authId, true));

		$this->app_id = $cfg->getString('application_id');
	}

	/**
	 * Initiate authentication.
	 *
	 * @param array &$state  Information about the current authentication.
	 */
	public function authenticate(&$state) {
		$id = SimpleSAML_Auth_State::saveState($state, 'aselectagent:login', true);

		$app_url = SimpleSAML_Module::getModuleURL('aselectagent/credentials.php', array('ssp_state' => $id));
		$as_url = aselect_authenticate($this->app_id, $app_url);
		if(is_null($as_url))
			SimpleSAML_Auth_State::throwException($state, new SimpleSAML_Error_Exception("Unable to acquire A-Select login URL"));

		SimpleSAML_Utilities::redirect($as_url);
	}
}
