# $Id: Database.pm 40260 2013-09-20 13:54:39Z anton $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/pwdmodifier/libpwdmodifier/lib/UvT/PwdModifier/Database.pm $
use strict;
use warnings FATAL => 'all';

package UvT::PwdModifier::Database;
use Spiffy -Base;

use IO::File;
use XML::LibXML;
use Fcntl qw(:flock);
field 'dir', -init => 'die "no token directory configured\n"';

sub createLock {
	my $dir = $self->dir;
	my $name = "$dir/lock";
	my $fh = new IO::File($name, '>')
		or die "can't open lockfile '$name': $!";
	flock($fh, LOCK_EX)
		or die "can't lock $name: $!";
	return $fh;
}

sub set {
 	my ($name, $content) = @_;
	$name = lc($name);

	my $doc = new XML::LibXML::Document('1.0', 'UTF-8');
	my $root = $doc->createElement('token');
	$doc->setDocumentElement($root);

	while(my ($key, $val) = each(%$content)) {
		$root->appendTextChild($key, $val);
	}

	my $dir = $self->dir;
	my $lock = $self->createLock;

	eval { $doc->toFile("$dir/tmp/$name", 1) };
	die "$dir/tmp/$name: $@" if $@;

	rename("$dir/tmp/$name", "$dir/new/$name")
		or die "$dir/new/$name: $!";

	return $name;
}

sub get {
	my $name = shift;
	my $dir = $self->dir;

	$name = lc($name);
	return unless -f "$dir/new/$name";

	my $parser = new XML::LibXML;
	$parser->pedantic_parser(1);
	$parser->validation(0);
	$parser->load_ext_dtd(0);
	$parser->expand_entities(0);
	$parser->keep_blanks(0);
	$parser->line_numbers(1);

	my $doc = $parser->parse_file("$dir/new/$name");

	my %res;
	my $root = $doc->documentElement;
	foreach my $node ($root->childNodes) {
		my $name = $node->nodeName;
		next unless $name;
		die "node '$name' must be unique"
			if exists $res{$name};
		$res{$name} = $node->textContent;
	}
	return \%res;
}

sub del {
	my $lock = $self->createLock;

	my $name = $_[0];

	my $dir = $self->dir;
	rename("$dir/new/$name", "$dir/cur/$name")
		or die "$dir/cur/$name: $!";
}
