# $Id: AAA.pm 40158 2013-09-13 13:06:28Z anton $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/pwdmodifier/libpwdmodifier/lib/UvT/PwdModifier/AAA.pm $

use strict;
use warnings FATAL => 'all';

package UvT::PwdModifier::AAA;

use Spiffy -Base;

field 'cf', -init => 'die "no cf configured\n"';
field 'dir', -init => 'die "no directory specified\n"';

sub verify_password {
	return $self->dir->verify_password(@_);
}

sub verify_ipaddress {
	my $ipaddress = shift;

	my $cf = $self->cf;
	my $adminipacl = $cf->value('adminipacl');
	die $cf->error if $cf->error;

	return if $ipaddress =~ /$adminipacl/;

	return "address: '$ipaddress' outside of range ($adminipacl)";
}

sub verify_authorization {
	my ($admin, $victim) = @_;
	warn "verifying authorization, admin: $admin, victim: $victim";

	my $dir = $self->dir;

 	# 1) fetch de org.stat. van het victim en zijn uvt-lau attrs
	my ($entry, $err) = $dir->getAccount($victim);
	return $err || 'failed' unless $entry;

	my @orgstats = $entry->orgstats;
	my @uvtlaus = $entry->laus;
#	warn "orgstats: @orgstats";
#	warn "uvtlaus: @uvtlaus";

	# 2) stel een lijst samen
	my %auths = ('pwd_change' => undef);
	foreach my $orgstat (@orgstats) {
		$orgstat = lc $orgstat;

		undef $auths{"pwd_change/$orgstat"};
		foreach my $uvtlau (@uvtlaus) {
			$uvtlau = lc $uvtlau;
			undef $auths{"pwd_change/$uvtlau/$orgstat"};
			undef $auths{"pwd_change/$uvtlau"};
		}
	}

	# 3) zoek op die lijst
	$err = $dir->check_uvt_auth($admin, [keys %auths]);
	if($err) {
		warn "admin: $admin is not authorized";
		return "$err, $admin is not allowed to administrate account: $victim";
	} else {
		warn "admin: $admin is authorized to administrate account: $victim";
		return;
	}
}
#
#sub getFallbackPassword {
#	my ($password, $addedString) = @_;
#	warn "orig: $password";
#	my $ctx = Digest::SHA1->new;
#	$ctx->add($password.$addedString);
#	my $digest = $ctx->digest;
#	my $converted = MIME::Base64::encode_base64($digest);
#	# vergeet niet de \n eraf te slopen!
#	chomp $converted;
#	$converted;
#}
