#!/usr/bin/perl

# $Id: fwsm_cpu_usage_hr.pl 8151 2013-08-12 09:04:16Z hurko $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/script/fwsm_cpu_usage_hr.pl $

use strict;
use warnings FATAL => 'all';

use UvT::NOC::Net::SSH2; 
use UvT::NOC::Util::StringUtil;

# ip van admin context primaire fwsm
# TODO : zou eigenlijk via input moeten komen, maar fwsm gaan geen jaren meer mee
my $ip = "172.31.12.4"; 

# de output van het 'show cpu usage context all' ophalen van de actieve fwsm
# TODO : user en wachtwoord uit globale config lezen
my $ssh_output = getInfoBySSHCliCommand($ip, "cw2k", "DwvhnwUvTbca6Mfl", "enable\nDwvhnwUvTbca6Mfl\nchangeto context system\nshow cpu usage context all\nquit\n");

# output ziet er als volgt uit :
#
# fwsm-prim/act# show cpu usage context all
#  5 sec  1 min  5 min  Context Name
#   1.5%   1.9%   2.2%  system
#   0.5%   1.8%   0.9%  admin
#   0.1%   0.3%   0.3%  its-giw
#   0.1%   0.2%   0.2%  few-frontend
#   3.8%   4.5%   5.2%  alg-ms
# fwsm-prim/act#

my %fwsm_context_cpu_usage = ();

my @lines = split /\n/, $ssh_output;
foreach my $line (@lines)
{
	# check of de regel matcht met 3 percentages en een contextnaam
	if ($line =~ m/\s+(\d+\.\d)%\s+(\d+\.\d)%\s+(\d+\.\d)%.\s+(.*)\s+$/)
	{
		# in cacti wordt minimaal het 5 minuten gemiddelde getekend, dus lezen we die hier uit
		# waarde zou verkleint kunnen worden als de interval van cacti ook verkleind wordt, gaat niet gebeuren
		my $cpu5min = trim($3);
		my $context = $4;

		# sla 5 min cpu usage op in een hash met contextnaam als key
		$fwsm_context_cpu_usage{$context} = trim($cpu5min);
	}
}

# print de cacti-output in het door cacti leesbare formaat :
# system:2.2 admin:0.9 few-frontend:0.2 alg-ms:5.2

my $output = "";

for my $context_name ( keys %fwsm_context_cpu_usage )
{
        my $cpu_usage = $fwsm_context_cpu_usage{$context_name};
        $output .= "$context_name:$cpu_usage ";
}

print trim($output);




