#!/usr/bin/perl

# $Id: wireless_client_traphic_received.pl 7604 2013-04-11 09:31:51Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/contrib/wireless_client_traphic_received.pl $

use warnings 'all';
use strict;
use File::stat;
use Time::localtime;
use Data::Dumper;

my $temp_file = "/tmp/wlc.received";

# het aantal bytes wat per controller is ontvangen
# dit wordt berekend door het verschil in counters per verbinding per controller op te tellen
my %totalTraphicPerControllerReceived = ();

# hashes voor alles huidige rx/tx counters en de counters van de vorige run
my %currentReceivedCountersPerController = ();
my %previousReceivedCountersPerController = ();


### READ SNMP-DATA FROM PREVIOUS RUN BY TEMP FILE ###

# als er ooit een vorige run is geweest, dan de counters inlezen en in hash opslaan (subje van maken...)
my $previousTime = 0;
if (-e $temp_file)
{
        $previousTime = stat($temp_file)->mtime;
        open(WLCDATA_READ, $temp_file);
        while (<WLCDATA_READ>)
        {
                my @line = split(/\|/);
                $previousReceivedCountersPerController{&trim($line[0])}->{&trim($line[1])} = &trim($line[2]);
        }
        close(WLCDATA_READ);
}


### READ NEW SNMP-DATA FROM CONTROLLERS ###

# open handle naar de temp-file
open(WLCDATA_WRITE, ">$temp_file");

# lees nieuwe controller data uit en sla in temp-file op
# tevens wordt de nieuwe uitgelezen data ook in de current counters hash opgeslagen
&getWLCTraphic("172.20.16.7", "wism-prim1");
&getWLCTraphic("172.20.16.9", "wism-prim2");
&getWLCTraphic("172.20.16.11", "wism-sec1");
&getWLCTraphic("172.20.16.13", "wism-sec2");

# klaar met uitlezen, sluit file-handle
close(WLCDATA_WRITE);
my $currentTime = stat($temp_file)->mtime;


### CALCULATE BYTES RECEIVED PER ID FOREACH CONTROLLER ###

foreach my $controller (keys %currentReceivedCountersPerController)
{
        if (exists($previousReceivedCountersPerController{$controller}))
        {
                foreach my $entry (keys %{$currentReceivedCountersPerController{$controller}})
                {
                        if (exists($previousReceivedCountersPerController{$controller}->{$entry}))
                        {
                                my $currentReceived = $currentReceivedCountersPerController{$controller}->{$entry};
                                my $previousReceived = $previousReceivedCountersPerController{$controller}->{$entry};

                                if ($currentReceived > $previousReceived)
                                {
                                        my $diff = $currentReceived - $previousReceived;
                                        $totalTraphicPerControllerReceived{$controller} = $totalTraphicPerControllerReceived{$controller} + $diff;
                                }
                        }
                }
        }
}

# bereken tijdspan tussen huidige en vorige uitlees actie (is nodig om de gauge bytes/sec te maken)
my $diffTime = $currentTime - $previousTime;

# loop door de hash heen om de output te genereren
# let op, aantal bytes received per controller delen door tijdspanne !!!
my $output = "";
foreach my $contr (keys %totalTraphicPerControllerReceived)
{
        my $bytesReceivedGauge = $totalTraphicPerControllerReceived{$contr} / $diffTime;
        $output = $output . "$contr:$bytesReceivedGauge ";
}

print &trim($output);

sub getWLCTraphic($_)
{
        $totalTraphicPerControllerReceived{$_[0]} = 0;
# dpipvk
        open(RECEIVED, "snmpwalk -v2c -cdpipvk $_[0] 1.3.6.1.4.1.14179.2.1.6.1.2 |");
        while (<RECEIVED>)
        {
                if (/\.(\S+).*?:\s+(\d+)/)
                {
                        $currentReceivedCountersPerController{$_[0]}->{$1} = $2;
                        print WLCDATA_WRITE "$_[0]|$1|$2\n";
                }
        }
}

# Perl trim function to remove whitespace and carriage return from the start and end of the string
sub trim($)
{
  my $string = shift;
  $string =~ s/^\s+//;
  $string =~ s/\s+$//;
  return $string;
}

