#!/usr/bin/perl

# $Id: switch_temperatures.pl 8157 2013-08-12 12:34:28Z hurko $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/script/switch_temperatures.pl $

use strict;
use warnings FATAL => 'all';

# wellicht gaat de toch wat specifieke functie getMaxWalkValueBySNMPv2 naar de NOC::Net::SNMP library
use UvT::NOC::Net::SNMP;
use UvT::NOC::Util::StringUtil;
use Data::Dumper;

if ($#ARGV < 0)
{
        print "Usage $0 <ip 1> <ip 2> ...\n";
        print "\t<ip n> = ip address of device\n";
        exit 0;
}

my %devices = ();

foreach my $arg (0 .. $#ARGV)
{
	$devices{$ARGV[$arg]} = 0;
}

# TODO : snmp community gegevens uit global config halen
my $snmp_community = "hkbu4kma";
my $snmp_options   = "-Oqv";

my $ciscoEnvMonTemperatureStatusValue = ".1.3.6.1.4.1.9.9.13.1.3.1.3";

# Haal per device de maximale temperatuur van de betreffende switch-stack op
foreach my $device (keys %devices)
{
        my $maxTemp = getMaxWalkIntValueBySNMPv2($device, $snmp_community, $ciscoEnvMonTemperatureStatusValue, $snmp_options);
        $devices{$device} = $maxTemp ? $maxTemp : "NaN";
}

# print de cacti-output in het door cacti leesbare formaat :
# fd-l197a:40 fd-l187a:47

my $output = "";

foreach my $device (keys %devices)
{
	$output = $output . "$device:$devices{$device} ";
}

print trim($output);


