#!/usr/bin/perl

# $Id: router_fwsm_traffic.pl 8154 2013-08-12 12:06:30Z hurko $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/script/router_fwsm_traffic.pl $

use strict;
use warnings FATAL => 'all';

use UvT::NOC::Net::SNMP; 
use UvT::NOC::Util::StringUtil;

if ($#ARGV != 6)
{
	print "Usage $0 <ip> <ifIndex 1> <ifIndex 2> <ifIndex 3> <ifIndex 4> <ifIndex 5> <ifIndex 6>\n";
	print "\t<ip>      = ip of router containing FWSM module\n";
	print "\t<ifIndex n> = index number of FWSM Gigabit interface\n";
	exit 0;
}

my $ip = $ARGV[0];               # router ip which contains fwsm
my @index = @ARGV[ 1 .. $#ARGV]; # array of interface indexes (Gi1/1 .. Gi1/6)

# TODO : snmp community gegevens uit global config halen
my $snmp_community = "hkbu4kma";
my $snmp_options   = "-Oqv";

my $ifHCInOctets  = ".1.3.6.1.2.1.31.1.1.1.6";
my $ifHCOutOctets = ".1.3.6.1.2.1.31.1.1.1.10";

# Totaal aantal verzonden en ontvangen bits van de 6 interfaces bij elkaar opgeteld
my $totalTrafficIn = 0;
my $totalTrafficOut = 0;

# Lees voor elke index (Gi1/x interface) van de fwsm het aantal verzonden en ontvangen bits uit
foreach my $index (@index)
{
	my $trafficOut = getInfoBySNMPv2($ip, $snmp_community, $ifHCOutOctets . "." . $index, $snmp_options);
	my $trafficIn = getInfoBySNMPv2($ip, $snmp_community, $ifHCInOctets . "." . $index, $snmp_options);

	# Voeg deze waarde toe aan het totaal
	$totalTrafficIn += $trafficIn;
	$totalTrafficOut += $trafficOut;
}

# print de cacti-output in het door cacti leesbare formaat :
# traffic_in:857919470255233 traffic_out:867366315036221

print "traffic_in:$totalTrafficIn traffic_out:$totalTrafficOut";
