#!/usr/bin/perl

# $Id: $
# $URL: $

use strict;
use warnings FATAL => 'all';

use UvT::NOC::InfraStructure::AccessPointList;
use UvT::NOC::Net::SNMP; 
use UvT::NOC::Util::StringUtil;

use Data::Dumper;

if ($#ARGV < 0)
{
    print "Usage $0 <ap-name 1> <ap-name 2> ... or \n";
    print "\t<ap-name n> = name of access points or enter '--all'\n";
	print "Or use : $0 --building <building acronym>\n";
	print "Or use : $0 --allbuildings\n\n";
    exit 0;
}

my $apList = new UvT::NOC::InfraStructure::AccessPointList();

my %buildingClientCount = ();
my @buildings = ('a', 'c', 'd', 'e', 'f', 'g', 'k', 'l', 'm', 'ne', 'nv', 'o', 'p', 'r', 's', 't', 'tu', 'v', 'w', 'x', 'unknown');
my @values    = ('0', '0', '0', '0', '0', '0', '0', '0', '0', '0',  '0',  '0', '0', '0', '0', '0', '0' , '0', '0', '0', '0'      );
@buildingClientCount{@buildings} = @values;

my @controllers = ('172.20.32.12', '172.20.32.13');

# TODO : snmp community gegevens uit global config halen
my $snmp_community = "hkbu4kma";
my $snmp_options   = "-On";

my $bsnAPName           = ".1.3.6.1.4.1.14179.2.2.1.1.3";
my $bsnAPDot3MacAddress	= ".1.3.6.1.4.1.14179.2.2.1.1.1";
my $cldcApMacAddress    = ".1.3.6.1.4.1.9.9.599.1.3.1.1.8";

# haal de accesspoint namen, id's en load gegevens op en sla deze op in de datastrucuur AccessPointList $apList
for my $i (0 .. $#controllers)
{
	my $controller = $controllers[$i];
	getAPNamesAndIDs($apList, $bsnAPName, walkInfoBySNMPv2($controller, $snmp_community, $bsnAPName, $snmp_options));
	getAPBaseMacs($apList, $bsnAPDot3MacAddress, walkInfoBySNMPv2($controller, $snmp_community, $bsnAPDot3MacAddress, $snmp_options));
	getAPClientLoad($apList, $cldcApMacAddress, walkInfoBySNMPv2($controller, $snmp_community, $cldcApMacAddress, "-Oqv"));
}

my $clientCount = 0;

if ($ARGV[0] eq '--all')
{
	foreach my $ap ($apList->getAccessPoints)
	{
		my $apName = $ap->name;

		if (defined($ap->{clients})) { $clientCount += $ap->clients; }
	}
	print "clients:$clientCount";
}
elsif ($ARGV[0] eq '--allbuildings')
{	
	foreach my $ap ($apList->getAccessPoints)
	{
		my $apName = lc($ap->name);
#print "$apName \t\t";
		if ( $apName =~ /^ap-(.*?)(\d+)([a-z])/i && index($apName, '.') == -1)	
		{
#print "$1, $2, $3\t";
			my $apAcronym = $1;
			$apAcronym = $1 if ($apAcronym=~/(.*)z$/);
#print "Acronym : $apAcronym\n";

			if (defined($ap->{clients}))
			{
				if (exists $buildingClientCount{$apAcronym})
				{
					$buildingClientCount{$apAcronym} += $ap->clients;
				}
				else
				{
#print "Unknown ap : $apName\n";
					$buildingClientCount{'unknown'} += $ap->clients;
				}
			}
		}
#		else
#		{
#			print "NO MATCH : $apName\n"; 
#		}
	}

	my $total = 0;
	foreach my $building (sort keys %buildingClientCount)
	{
		$total += $buildingClientCount{$building};
		print "$building:$buildingClientCount{$building} ";
	}
	print "total:$total";
}
elsif ($ARGV[0] eq '--building')
{
	my $building;
	eval { $building = lc($ARGV[1]); };
	if ($@)	{ die "No building acronym given\n"; }

	foreach my $ap ($apList->getAccessPoints())
    {
		my $prefix = "ap-" . $building;
        if ($ap->name =~ m/^$prefix/i)
		{
			if (defined($ap->{clients}))
			{
				$clientCount += $ap->clients;
			}
		};
    }
	print "clients:$clientCount";
}
else
{
	foreach my $arg (0 .. $#ARGV)
	{
		my $apName = $ARGV[$arg];

		if (my $ap = $apList->getAccessPointByName($apName))
		{
			$clientCount += $ap->clients;
		}
	}
	print "clients:$clientCount";
}





# Input ziet er als volgt uit :
# .1.3.6.1.4.1.14179.2.2.1.1.3.100.217.137.70.248.144 = STRING: "ap-wz204a"
# .1.3.6.1.4.1.14179.2.2.1.1.3.100.217.137.70.248.192 = STRING: "ap-s208c"
# .1.3.6.1.4.1.14179.2.2.1.1.3.100.217.137.70.248.208 = STRING: "ap-t785b"
#
#
# Vult de data-structure AccessPointList ala :
#
# $VAR1 = bless( {
#                 'aps' => {
#                            'ap-d470a' => bless( {
#                                                   'name' => 'ap-d470a',
#                                                   'id' => '100.217.137.71.20.112'
#                                                 }, 'UvT::NOC::InfraStructure::AccessPoint' ),
#                            'ap-l51a' => bless( {
#                                                  'name' => 'ap-l51a',
#                                                  'id' => '100.217.137.70.246.192'
#                                                }, 'UvT::NOC::InfraStructure::AccessPoint' )
#                          }
#               }, 'UvT::NOC::InfraStructure::AccessPointList' );

sub getAPNamesAndIDs
{
	my $apList = shift;
	my $oid = shift;
	my @snmp_result = split /\n/, shift;

	foreach my $line (@snmp_result)
	{
		my $snmp_line = trim($line);
		$snmp_line = stringReplace($oid . ".", "", $snmp_line);

		my $apID = trim(substr($snmp_line, 0, index($snmp_line, '=')));
		my $apName = trim(substr($snmp_line, index($snmp_line, '"') + 1, rindex($snmp_line, '"') - index($snmp_line, '"') - 1));

		$apList->addAccessPoint(new UvT::NOC::InfraStructure::AccessPoint(name => $apName, id => $apID));
	}
}



# Voeg base mac van ap toe aan het bijborende AccessPoint object
#
# $VAR1 = bless( {
#                 'name' => 'ap-s208c',
#                 'id' => '100.217.137.70.248.192',
#            -->  'mac' => '64 D9 89 46 F8 C0'  <---
#               }, 'UvT::NOC::InfraStructure::AccessPoint' );

sub getAPBaseMacs
{
	my $apList = shift;
	my $oid = shift;
	my @snmp_result = split /\n/, shift;

	foreach my $line (@snmp_result)
    {
		my $snmp_line = trim($line);
		$snmp_line = stringReplace($oid . ".", "", $snmp_line);

		my $apID = trim(substr($snmp_line, 0, index($snmp_line, '=')));
        my $apValue = trim(removeQuotes(trim(substr($snmp_line, rindex($snmp_line, ':') + 1, length($snmp_line) - rindex($snmp_line, ':') - 1))));

		$apList->getAccessPointByID($apID)->{mac} = $apValue;

		# print $snmp_line . "    apID : " . $apID . "   apValue : " . $apValue . "\n"; 
	}
}



# Voegt load info toe aan het object AccessPoint in de AccessPointList ala :
# 	(loopt door alle clients en op basis van mac adres
# 	van accesspoint wordt deze aan $apList toegevoegd)
#
# $VAR1 = bless( {
#            -->  'clients' => 5,  <---
#                 'name' => 'ap-s208c',
#                 'id' => '100.217.137.70.248.192',
#                 'mac' => '64 D9 89 46 F8 C0'
#               }, 'UvT::NOC::InfraStructure::AccessPoint' );

sub getAPClientLoad
{	
	my $apList = shift;
	my $oid = shift;
	my @snmp_result = split /\n/, shift;

	foreach my $line (@snmp_result)
	{
		my $snmp_line = trim($line);
		my $apMACAddress = trim(removeQuotes($snmp_line));

		$apList->getAccessPointByMACAddress($apMACAddress)->{clients} += 1;
	}
}



