#!/usr/bin/perl

# $Id: fwsm_np_stats_hr.pl 8158 2013-08-12 12:57:06Z hurko $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/script/fwsm_np_stats_hr.pl $

use strict;
use warnings FATAL => 'all';

use UvT::NOC::Net::SSH2; 
use UvT::NOC::Util::StringUtil;

if ($#ARGV != 0)
{
	print "Usage $0 <np>\n";
	print "\t<np> = number of Fast Path network processor (1 or 2)\n";
	exit 0;
}

my $np = $ARGV[0];

# ip van admin context primaire fwsm
# TODO : zou eigenlijk via input moeten komen, maar fwsm gaan geen jaren meer mee
my $ip = "172.31.12.4";

# de (gedeeltelijke) output van het 'show np 0/1 stats' ophalen van de actieve fwsm
# TODO : user en wachtwoord uit globale config lezen
my $ssh_output = getInfoBySSHCliCommand($ip, "cw2k", "DwvhnwUvTbca6Mfl", "enable\nDwvhnwUvTbca6Mfl\nchangeto context system\nterminal pager 0\nshow np $np stats | include pause|total packets|packets from|packets to|other blade|pkt drop\nquit\n");


# print de cacti-output in het door cacti leesbare formaat :
# total_packets_received:474754832004 total_packets_sent:472664300181 total_packets_dropped:750487291 packets_to_np3:2656065763 packets_from_np3:1107320929 packets_to_fwsm:1817432295 packets_from_fwsm:1997080022 packets_to_other_blade:3471113264 packets_from_other_blade:2759604136 pkt_drop_l2:554906149 pkt_drop_l3:830 pkt_drop_l4:28282029 pause_frames_sent:35612085

my $output = "";

my @lines = split /\n/, $ssh_output;
foreach my $line (@lines)
{
	#print "$line\n";
	if ($line =~ m/^PKT_MNG:(.*)rcvd\s+:\s(\d+)/)
    {
		$output .= "total_packets_received:$2 ";
    }
    if ($line =~ m/^PKT_MNG:(.*)sent\s+:\s(\d+)/)
    {
		$output .= "total_packets_sent:$2 ";
    }
    if ($line =~ m/^PKT_MNG:(.*)dropped\s+:\s(\d+)/)
    {
		$output .= "total_packets_dropped:$2 ";
    }


    if ($line =~ m/^PKT_MNG:(.*)to NP-3\s+:\s(\d+)/)
    {
		$output .= "packets_to_np3:$2 ";
    }
    if ($line =~ m/^PKT_MNG:(.*)from NP-3\s+:\s(\d+)/)
    {
		$output .= "packets_from_np3:$2 ";
    }

    if ($line =~ m/^PKT_MNG:(.*)to FWSM\s+:\s(\d+)/)
    {
		$output .= "packets_to_fwsm:$2 ";
    }
    if ($line =~ m/^PKT_MNG:(.*)from FWSM\s+:\s(\d+)/)
    {
		$output .= "packets_from_fwsm:$2 ";
    }


    if ($line =~ m/^PKT_MNG:(.*)to other blade\s+:\s(\d+)/)
    {
		$output .= "packets_to_other_blade:$2 ";
    }
    if ($line =~ m/^PKT_MNG:(.*)from other blade\s+:\s(\d+)/)
    {
		$output .= "packets_from_other_blade:$2 ";
    }


    if ($line =~ m/^PKT_MNG: pkt drop \(l2(.*)\s+:\s(\d+)/)
    {
		$output .= "pkt_drop_l2:$2 ";
    }
    if ($line =~ m/^PKT_MNG: pkt drop \(l3(.*)\s+:\s(\d+)/)
    {
		$output .= "pkt_drop_l3:$2 ";
    }
    if ($line =~ m/^PKT_MNG: pkt drop \(l4(.*)\s+:\s(\d+)/)
    {
		$output .= "pkt_drop_l4:$2 ";
    }


    if ($line =~ m/^PF_MNG: pause(.*)\s+:\s(\d+)/)
    {
		$output .= "pause_frames_sent:$2";
    }
}

print trim($output);
