#!/usr/bin/perl

# $Id: fwsm_cpu_usage_hr.pl 7603 2013-04-11 09:28:27Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/script/fwsm_cpu_usage_hr.pl $

use strict;
use warnings FATAL => 'all';

use NOC::Net::SSH2; 
use NOC::Util::StringUtil;

my $ip = "172.31.12.4";

my $ssh_output = getInfoBySSHCliCommand($ip, "cw2k", "DwvhnwUvTbca6Mfl", "enable\nDwvhnwUvTbca6Mfl\nchangeto context system\nshow cpu usage context all\nquit\n");

my %fwsm_context_cpu_usage = ();

my @lines = split /\n/, $ssh_output;
foreach my $line (@lines)
{
	if ($line =~ m/\s+(\d+\.\d)%\s+(\d+\.\d)%\s+(\d+\.\d)%.\s+(.*)\s+$/)
	{
		#print "match : $line\n";
		my $cpu5min = trim($3);
		my $context = $4;
		#print "cpu usage $context : $cpu5min\n";
		#print ">$1< >$2< >$3< >$4<\n";
		$fwsm_context_cpu_usage{$context} = trim($cpu5min);
	}
}

my $output = "";
for my $context_name ( keys %fwsm_context_cpu_usage )
{
        my $cpu_usage = $fwsm_context_cpu_usage{$context_name};
        $output .= "$context_name:$cpu_usage ";
}

print trim($output);
