#!/usr/bin/perl

# $Id: linux_memory.pl 7602 2013-04-11 09:27:20Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/script/linux_memory.pl $

use strict;
use warnings FATAL => 'all';

use IO::File;

my $filename = "/proc/meminfo";

my $file = new IO::File($filename) or die "Could not open $filename: $!\n";

my %memInfo = ();

while (my $line = $file->getline())
{
	#print "Line $. : $line";
	if ($line =~ m/^(\S+):\s+(\S+) (\S+)/ )
	{
		# print "Object 1 : $1, object 2 : $2, object 3 : $3\n";
		$memInfo{$1} = $2;	
	}
}
$file->close;

# From /proc/meminfo : MemTotal, MemFree, Buffers, Cached, SwapTotal, SwapFree, SwapCached
# MemUsed = MemTotal - MemFree - Buffers - Cached 
# SwapUsed = SwapTotal - SwapFree
my $availReal = $memInfo{MemTotal} - $memInfo{MemFree} - $memInfo{Buffers} - $memInfo{Cached};
my $usedReal = $memInfo{MemTotal} - $availReal - $memInfo{Buffers} - $memInfo{Cached};
my $usedSwap = $memInfo{SwapTotal} - $memInfo{SwapFree};

# totalReal, availReal, usedReal, memCached, totalSwap, usedSwap, availSwap
print "totalReal:" . $memInfo{MemTotal} . " usedReal:" . $usedReal . " availReal:" . $availReal . " memBuffers:" . $memInfo{Buffers} . " memCached:" . $memInfo{Cached} . " usedSwap:" . $usedSwap ;
