#!/usr/bin/perl

use strict;
use warnings FATAL =>'all';

use IO::File;
use Data::Dumper;

my $procStatFile = "/proc/stat";

my $cpuCount = countCPU($procStatFile);
#print "Number of cpus : $cpuCount\n";

my @cpuStats;

# get initial cpu stats
getCPUStats($procStatFile, $cpuCount);
# wait
sleep 1;
# get cpu stats again for calculating cpu usage during period
getCPUStats($procStatFile, $cpuCount);


# print Dumper(@cpuStats);
for (my $i = 0; $i < $cpuCount; $i++)
{
	my $cpuid = $cpuStats[$i]{'cpuId'};
	my $total = $cpuStats[$i]{'totalPeriod'} == 0 ? 1 : $cpuStats[$i]{'totalPeriod'};

	my $nicePeriod = $cpuStats[$i]{'nicePeriod'} / $total * 100;
	my $userPeriod = $cpuStats[$i]{'userPeriod'} / $total * 100;
	my $systemAllPeriod = $cpuStats[$i]{'systemAllPeriod'} / $total * 100;
	my $virtualAllPeriod = $cpuStats[$i]{'stealPeriod'} + $cpuStats[$i]{'guestPeriod'} / $total * 100;

	my $percent = $nicePeriod + $userPeriod + $systemAllPeriod + $virtualAllPeriod;
	$percent = sprintf "%.2f", $percent;

#	print ">> total $cpuid : $total\n";
#	print "nice $cpuid : $nicePeriod\n";
#	print "user $cpuid : $userPeriod\n";
#	print "system all $cpuid : $systemAllPeriod\n";
#	print "virtual all $cpuid : $virtualAllPeriod\n";

	print "$cpuid:$percent ";

	
}


sub getCPUStats
{
	my ($filename, $cpuCount) = @_;
	my @stats = ();

	for (my $i = 0; $i < $cpuCount; $i++)
	{
		# print "i : $i\n";
		my $file = new IO::File($filename) or die "Could not open $filename: $!\n";
		while (my $line = $file->getline())
		{
			if ($line =~ m/^cpu$i\s+[0-9]+/)
			{
				my @cpu = split /\s+/, $line;
				my $cpuId      = $cpu[0];
				my $userTime   = $cpu[1];
				my $niceTime   = $cpu[2];
				my $systemTime = $cpu[3];
				my $idleTime   = $cpu[4];
				my $ioWait     = $cpu[5];
				my $irq        = $cpu[6];
				my $softIrq    = $cpu[7];
				my $steal      = $cpu[8];
				my $guest      = $cpu[9];

				my $idleAllTime   = $idleTime + $ioWait;
				my $systemAllTime = $systemTime + $irq + $softIrq;
				my $virtAllTime   = $steal + $guest;
				my $totalTime     = $userTime + $niceTime + $systemAllTime + $idleAllTime + $virtAllTime;

				$cpuStats[$i]{'userPeriod'}      = $userTime      - (exists($cpuStats[$i]{'userTime'})      ? $cpuStats[$i]{'userTime'}      : 0 );
				$cpuStats[$i]{'nicePeriod'}      = $niceTime      - (exists($cpuStats[$i]{'niceTime'})      ? $cpuStats[$i]{'niceTime'}      : 0 );
				$cpuStats[$i]{'systemPeriod'}    = $systemTime    - (exists($cpuStats[$i]{'systemTime'})    ? $cpuStats[$i]{'systemTime'}    : 0 );
				$cpuStats[$i]{'systemAllPeriod'} = $systemAllTime - (exists($cpuStats[$i]{'systemAllTime'}) ? $cpuStats[$i]{'systemAllTime'} : 0 );

				$cpuStats[$i]{'idlePeriod'}      = $idleTime      - (exists($cpuStats[$i]{'idleTime'})      ? $cpuStats[$i]{'idleTime'}      : 0 );
				$cpuStats[$i]{'idleAllPeriod'}   = $idleAllTime   - (exists($cpuStats[$i]{'idleAllTime'})   ? $cpuStats[$i]{'idleAllTime'}   : 0 );
				$cpuStats[$i]{'ioWaitPeriod'}    = $ioWait        - (exists($cpuStats[$i]{'ioWaitTime'})    ? $cpuStats[$i]{'ioWaitTime'}    : 0 );
				$cpuStats[$i]{'irqPeriod'}       = $irq           - (exists($cpuStats[$i]{'irqTime'})       ? $cpuStats[$i]{'irqTime'}       : 0 );

				$cpuStats[$i]{'softIrqPeriod'}   = $softIrq       - (exists($cpuStats[$i]{'softIrqTime'})   ? $cpuStats[$i]{'softIrqTime'}   : 0 );
				$cpuStats[$i]{'stealPeriod'}     = $steal         - (exists($cpuStats[$i]{'stealTime'})     ? $cpuStats[$i]{'stealTime'}     : 0 );
				$cpuStats[$i]{'guestPeriod'}     = $guest         - (exists($cpuStats[$i]{'guestTime'})     ? $cpuStats[$i]{'guestTime'}     : 0 );
				$cpuStats[$i]{'totalPeriod'}     = $totalTime     - (exists($cpuStats[$i]{'totalTime'})     ? $cpuStats[$i]{'totalTime'}     : 0 );

				$cpuStats[$i]{'cpuId'}         = $cpuId;
				$cpuStats[$i]{'userTime'}      = $userTime;
				$cpuStats[$i]{'niceTime'}      = $niceTime;
				$cpuStats[$i]{'systemTime'}    = $systemTime;
				$cpuStats[$i]{'systemAllTime'} = $systemAllTime;
				$cpuStats[$i]{'idleTime'}      = $idleTime;
				$cpuStats[$i]{'idleAllTime'}   = $idleAllTime;
				$cpuStats[$i]{'ioWaitTime'}    = $ioWait;
				$cpuStats[$i]{'irqTime'}       = $irq;
				$cpuStats[$i]{'softIrqTime'}   = $softIrq;
				$cpuStats[$i]{'stealTime'}     = $steal;
				$cpuStats[$i]{'guestTime'}     = $guest;
				$cpuStats[$i]{'totalTime'}     = $totalTime;



     # cpuData->userPeriod = usertime - cpuData->userTime;
			}
		}
		#print "$_ = $statsPerCore{$_}\n" for keys %statsPerCore;
	}
}


sub countCPU
{
	my $filename = shift;
	my $cpuCount = 0;
	my $file = new IO::File($filename) or die "Could not open $filename: $!\n";
	while (my $line = $file->getline())
	{
		if ($line =~ m/^cpu/)
		{
			$cpuCount++;
		}
	}

	return $cpuCount - 1;
}
