package nl.uvt.locator;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import nu.xom.Document;
import nl.uvt.commons.io.*;

public class TucatConnection {

	class tuCQL extends CQLfields {
		public void fill() {
			currentPrefix = "tucat.";
			String val = Locator.locatorConfig.getProperty( currentPrefix+"issnSelector", "pica.iss=" );
			issnSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"isbnSelector", "pica.isb=" );
			isbnSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"epnSelector", "pica.epn=" );
			epnSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"dateSelector", "pica.jvu=" ); 
			dateSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"titleSelector", "pica.ttl=");
			titleSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"subTitleSelector", "pica.ttl=" );
			subTitleSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"fullTitleSelector", "pica.htl=" );
			fullTitleSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"locationSelector", "pica.sig=" );
			locationSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"authorSelector", "pica.aut=" );
			authorSelector = val.replaceAll("\"","");
			// NO repository selector
		}
		
	}
	
	tuCQL cqlData = new tuCQL();
	
	List<LocatorInfo> query( QueryData pQ ) throws LocatorException {
		cqlData.fill();
		List<LocatorInfo> meResult = null;
		String urlString = Locator.locatorConfig.getProperty("tucatUri");
		try {
			URL url = new URL( urlString );
			Properties props = new Properties( Locator.sruDefaultProps );
			props.setProperty("recordSchema","picamarc" );
			String query = CQLConnection.makeCQL( pQ, cqlData );
			if ( query.length() == 0 )
				// fails when no useful data is available
				return meResult;
			props.setProperty("query", query );
			props.setProperty("sortKeys","YOP,pica,0" );
			Document result = Http.httpGetDocument( url, props, Locator.httpConfig );
			if ( result != null ){
				int hits = Locator.extractHits( result );
				Locator.logger.debug("tucat numOfRecords=" + hits );
				if ( hits > 0 ){
					//					Locator.logger.debug( "tucat doc:" + result.toXML());
					String sheetName = Locator.locatorConfig.getProperty("tucatSheet");
					meResult = HoldingInfo.getModsResults( result, pQ, sheetName );
				}
			}
			else {
				Locator.logger.warn("No response from:" + url );
			}
		}	
		catch ( Exception e) {
			throw new LocatorException( "Tucat URL: '" + urlString + "' failed"); 
		}
		return meResult;
	}

}
