package nl.uvt.locator;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import nu.xom.Document;
import nl.uvt.commons.io.*;

public class TolkConnection {

	class tolkCQL extends CQLfields {
		public void fill() {
			currentPrefix = "tolk.";
			String val = Locator.locatorConfig.getProperty( currentPrefix+"issnSelector", "pica.iss=" );
			issnSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"isbnSelector", "pica.isb=" );
			isbnSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"epnSelector", "pica.epn=" );
			epnSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"dateSelector", "pica.jvu=" ); 
			dateSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"titleSelector", "pica.ttl=");
			titleSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"subTitleSelector", "pica.ttl=" );
			subTitleSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"fullTitleSelector", "pica.tti=" );
			fullTitleSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"locationSelector", "pica.sig=" );
			locationSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"authorSelector", "pica.aut=" );
			authorSelector = val.replaceAll("\"","");
			// NO repository selector
		}

	}

	tolkCQL cqlData = new tolkCQL();

	List<LocatorInfo> dummyResult = new LinkedList<LocatorInfo>();

	public static String makeCQL( QueryData pQ, CQLfields cqlData ){
		String query = "";
		Locator.logger.debug("make CQL van " + pQ );
		if ( pQ.genre.equals( "article") ){
			if ( pQ.issn.length() > 0 ){
				query = cqlData.issnSelector + pQ.issn;
			}
			else if ( pQ.title.length() > 0 ){
				StringBuffer main = new StringBuffer();
				StringBuffer sub = new StringBuffer();
				String title = CQLConnection.filterTitle( pQ.title );
				CQLConnection.splitTitle( title, main, sub );
				title = main.toString();
				title = CQLConnection.filterStopWords( title );
				title = CQLConnection.picaFixTitle( title );
				query = cqlData.fullTitleSelector + "\"" + title + "\"";
			}
		}
		else if ( pQ.isbn.length() > 0 ){
			Locator.logger.debug("ISBN: " + pQ.isbn );
			if ( pQ.isbn.length() == 13 ){
				Locator.logger.debug("ISBN: is lang genoeg " + pQ.isbn.length() );
				query = cqlData.isbnSelector + pQ.isbn;
			}
			else if ( pQ.isbn.length() == 10 ){
				Locator.logger.debug("ISBN verlengen " );
				String isbn13 = CQLConnection.to13( pQ.isbn );
				query = cqlData.isbnSelector + pQ.isbn + " or " + cqlData.isbnSelector + isbn13;						
			}
		}
		else {
			String fullTitle = null;
			String mainTitle = "";
			String subTitle = "";
			if ( !pQ.genre.equals( "preprint" ) && pQ.title.length() > 0 ) {
				fullTitle = CQLConnection.filterTitle( pQ.title );
				StringBuffer main = new StringBuffer();
				StringBuffer sub = new StringBuffer();
				CQLConnection.splitTitle( fullTitle, main, sub );
				mainTitle = main.toString();
				subTitle = sub.toString();
			}
			else if ( pQ.atitle.length() > 0 ) {
				fullTitle = CQLConnection.filterTitle( pQ.atitle );
				mainTitle = fullTitle;
			}
			fullTitle = CQLConnection.picaFixTitle( fullTitle );
			mainTitle = CQLConnection.picaFixTitle( mainTitle );
			subTitle = CQLConnection.picaFixTitle( subTitle );
			if ( fullTitle != null ) {
				if ( !mainTitle.equals("") ){
					if ( subTitle.equals("") ){
						query = cqlData.titleSelector + "\"" + mainTitle + "\"";
					}
					else {
						query = cqlData.titleSelector + "\"" + mainTitle + "\" and " + cqlData.subTitleSelector + "\"" + subTitle + "\"";
					}
				}
			}
			String author = null;
			if ( !pQ.genre.equals("bookitem") && 	
					!pQ.genre.equals("proceeding") &&
					pQ.aulast.length() > 0 ){
				author = cqlData.authorSelector + "\"" + pQ.aulast + "\""; 
			}
			String date = null;
			if ( pQ.date > 0 ) {
				date = cqlData.dateSelector + "\"" + pQ.date + "\""; 
			}
			if ( author != null ){
				if ( query == null )
					query = author;
				else
					query += " and " + author;
			}
			if ( date != null )
				query += " and " + date;
		}
		return query;
	}

	List<LocatorInfo> query( QueryData pQ ) throws LocatorException {
		cqlData.fill();
		String urlString = Locator.locatorConfig.getProperty("tolkUri");
		urlString += "/DB=2.4/username=9960tolk/password=OBN005";
		try {
			URL url = new URL( urlString );
			Properties props = new Properties( Locator.sruDefaultProps );
			String query = makeCQL( pQ, cqlData );
			if ( query.length() == 0 )
				// fails when no useful data is available
				return null;
			props.setProperty("query", query );
			Locator.logger.debug("created query: " + props );
			Document result = Http.httpGetDocument( url, props, Locator.httpConfig );
			if ( result != null ){
				int hits = Locator.extractHits( result );
				Locator.logger.debug("tolk numOfRecords=" + hits );
				if ( hits > 0 ){
					//					Locator.logger.debug( "tolk doc:" + result.toXML());
					return dummyResult;
				}
			}
			else {
				Locator.logger.warn("No response from:" + url );
			}
		}	
		catch ( Exception e) {
			throw new LocatorException( "tolk URL: '" + urlString + "' failed"); 
		}
		return null;
	}

}
