package nl.uvt.locator;

import java.util.LinkedList;
import java.util.List;

import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.XPathContext;

public class Threshold {
	static enum thKind {unspec, nested, year, volume, issue};
	static enum thCondition { errorC, lt, le, ge, gt };
	static enum act { fail, pass, checkmore };

	int value;
	thKind kind = thKind.unspec;
	thCondition condition = thCondition.errorC;
	List<Threshold> more = new LinkedList<Threshold>();

	act compareYear( int year ) throws LocatorException {
		if ( kind != thKind.year ){
			if ( kind == thKind.unspec && more != null ){
				Locator.logger.debug( "recurse " );
				act result = act.pass;
				for ( int i=0; i < more.size() && result==act.pass; ++i ){
					result = more.get(i).compareYear( year );
				}
				Locator.logger.debug( "recurse result=" + result.toString() );
				return result;
			}
			else
				return act.pass;
		}
		else {
			Locator.logger.debug( "Compare Year: " + year + " " + condition.toString() + " " + value );
			act result = act.fail;
			switch ( condition ){
			case lt:
				if ( year < value )
					result = act.pass;
				break;
			case le:
				if ( year < value )
					result = act.pass;
				else if ( year == value )
					result = act.checkmore;
				break;
			case ge:
				if ( year > value )
					result = act.pass;
				else if ( year == value )
					result = act.checkmore;
				break;
			case gt:
				if ( year > value )
					result = act.pass;
				break;
			default:
				throw new LocatorException( "invalid threshold year condition" );
			}	
			if ( result == act.fail )
				Locator.logger.debug( "Threshold year rejected: " + year 
						+ " " + condition.toString() + " " + value );
			else if ( result == act.checkmore )
				Locator.logger.debug( "Threshold year need more checking... " + year );
			return result;
		}
	}

	act compareVolume( int volume, int issue ) throws LocatorException {
		act result = act.pass;
		if ( kind == thKind.volume ){
			Locator.logger.debug( "Compare Volume: " + volume + " " + condition.toString() + " " + value );
			if ( volume < 0 )
				return act.fail;
			switch ( condition ){
			case lt:
				if ( volume >= value )
					result = act.fail;
				break;
			case le:
				if ( volume == value )
					result = act.checkmore;
				else if ( volume > value )
					result = act.fail;
				break;
			case ge:
				if ( volume == value )
					result = act.checkmore;
				else if ( volume < value )
					result = act.fail;
				break;
			case gt:
				if ( volume < value )
					result = act.fail;
				break;
			default:
				throw new LocatorException( "invalid threshold volume condition" );
			}	
		}
		if ( result == act.fail )
			Locator.logger.debug( "Threshold volume rejected; " + volume 
					+ " " + condition.toString() + " " + value );
		else if ( more != null && issue != 0 && result == act.checkmore ){
			// when we are at the boundaries of a volume, check issue also
			if ( issue < 0 )
				return act.pass;
			for ( int i=0; i < more.size() && result==act.checkmore; ++i ){
				result = more.get(i).compareIssue( issue );
			}
		}
		return result;
	}

	act compareIssue( int issue ) throws LocatorException {
		if ( kind != thKind.issue )
			return act.checkmore;
		else {
			Locator.logger.debug( "Compare Issue:" + issue + " " + condition.toString() + " " + value );
			act result = act.fail;
			switch ( condition ){
			case lt:
				if ( issue < value )
					result = act.pass;
				break;
			case le:
				if ( issue <= value )
					result = act.pass;
				break;
			case ge:
				if ( issue >= value )
					result = act.pass;
				break;
			case gt:
				if( issue > value )
					result = act.pass;
				break;
			default:
				throw new LocatorException( "invalid threshold issue condition" );
			}	
			if ( result == act.fail )
				Locator.logger.debug( "Threshold issue rejected: " + issue + 
						" " + condition.toString() + " " + value );
			return result;
		}
	}


	public static boolean inRange( List<Threshold> thresholds, QueryData pQ) throws LocatorException{
	act test = act.pass;	
	if ( pQ.date > 0 ){
		for ( int i=0; i < thresholds.size(); ++i ){
			test = thresholds.get(i).compareYear( pQ.date );
			if ( test==act.fail && thresholds.get(i).kind!=thKind.unspec )
				break;
		}
	}
	if ( test != act.fail ){
		if ( pQ.thVolume > 0 ){
			for ( int i=0; i < thresholds.size() && test != act.fail ; ++i ){
				test = thresholds.get(i).compareVolume( pQ.thVolume, pQ.thIssue );
			}
		}
		else {
			test= act.pass;
		}
	}
	Locator.logger.debug( "Threshold final result: " + test.toString());
	return test==act.pass;
}

	protected String getValue( Node node, String val, XPathContext context){
		Nodes nodes = node.query( val, context);
		if ( nodes.size() > 0 ){
			return nodes.get(0).getValue();
		}
		else
			return "";
	}

	protected String getValue( Node node, String val ){
		return getValue( node, val, null );
	}

	void getValue( Node rec, String attribute, String valueString,  String operator ) {
		try {
			if ( attribute.equals("date") ) { 
				kind = thKind.year;
			}
			if ( attribute.equals("volume") ) { 
				kind = thKind.volume;
			}
			if ( attribute.equals("issue") ) { 
				kind = thKind.issue;
			}
			if ( operator.equals("ge") ){
				condition = thCondition.ge;
				value = Integer.parseInt(valueString.trim());
			}
			else if ( operator.equals("gt") ){
				condition = thCondition.gt;
				value = Integer.parseInt(valueString.trim()) ;
			}
			else if ( operator.equals("le") ){
				condition = thCondition.le;
				value = Integer.parseInt( valueString.trim());
			}
			else if ( operator.equals("lt") ){
				condition = thCondition.lt;
				value = Integer.parseInt( valueString.trim() );
			}
		}
		catch ( NumberFormatException e ){
			// quite a hack
			// some issues are entered like 2-3. Maybe Volumes too?
			// anyway: take the 'correct' value
			try {
				String[] parts = valueString.split("-");
				if ( parts.length == 2 ){
					if ( condition == thCondition.lt )
						value = Integer.parseInt( parts[0].trim() );
					else if ( condition == thCondition.le )
						value = Integer.parseInt( parts[1].trim() );
					else if ( condition == thCondition.gt )
						value = Integer.parseInt( parts[1].trim() );
					else if ( condition == thCondition.ge )
						value = Integer.parseInt( parts[0].trim() );
				}
				else {
					Locator.logger.warn("invalid '" + attribute + "' value in treshold:" + valueString );
					value = -1;
				}
			}
			catch ( NumberFormatException e2 ){
				Locator.logger.warn("invalid '" + attribute + "' value in treshold:" + valueString );
				value = -1;
			}
		}
	}

	boolean fill( Node rec ) {
		boolean result = true;
		String attribute = getValue( rec, "attribute ");
		String operator = getValue( rec, "operator" );
		String val = getValue( rec, "value" );
		getValue( rec, attribute, val, operator );
		Nodes nodes = rec.query( "threshold ");
		for ( int i=0; i < nodes.size(); ++i ){
			Threshold th = new Threshold();
			if ( !th.fill( nodes.get(i) ) )
				result = false;
			more.add( th );
		}
		return result;
	}

	boolean fill( Node rec, String ns, XPathContext context ) {
		boolean result = true;
//			Locator.logger.debug("fill from: " + rec.toXML() );
		String attribute = getValue( rec, ns+":attribute", context);
		String operator = getValue( rec, ns+":operator", context );
		String val = getValue( rec, ns+":value", context );
		getValue( rec, attribute, val, operator );
		Nodes nodes = rec.query( ns+":threshold", context );
		for ( int i=0; i < nodes.size(); ++i ){
			Threshold th = new Threshold();
			if ( !th.fill( nodes.get(i) ) )
				result = false;
			more.add( th );
		}
		return result;
	}

	public String toString(){
		return toString( false );
	}

	public String toString( boolean nested ){
		String result = "";
		if ( condition == thCondition.lt ){
			if ( !nested )
				result += "-"; 
			else {
				switch ( kind ){
				case year: 
				case volume:
					break;
				case issue:
					result += "/";
					break;
				}
			}
			result += value - 1;
		}
		else if ( condition == thCondition.le ){
			if ( !nested )
				result += "-"; 
			else {
				switch ( kind ){
				case year: 
				case volume:
					break;
				case issue:
					result += "/";
					break;
				}
			}
			result += value;
		}
		else if ( condition == thCondition.ge ){
			switch ( kind ){
			case  year: 
				result += " ";
				break;
			case volume:
				result += " ";
				break;
			case issue:
				result += "/";
				break;
			}
			result += value;
		}
		else if ( condition ==thCondition.gt){
			switch ( kind ){
			case  year: 
				result += " ";
				break;
			case volume:
				result += " ";
				break;
			case issue:
				result += "/";
				break;
			}
			result += value;
		}

		if ( more != null )
			for ( int i=0; i < more.size(); ++i ){
				result += more.get(i).toString( true );
			}
		return result;
	}
}
