package nl.uvt.locator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import java.net.URLDecoder;

public class QueryData {
	String genre;   
	String issn;
	String isbn;
	String title;
	String atitle;
	String aulast;
	String aufirst;
	String auinit1;
	String epn;
	String ppn;
	String publisher;
	String placepub;
	String sid;
	String doi;
	String recordid;
	String issue;
	String volume;
	String location;
	int date;
	int thVolume;
	int thIssue;
	String spage;
	String pages;
	QueryData(){
		genre = "article";
		issn = "";
		isbn = "";
		title = "";
		atitle = "";
		aulast = "";
		aufirst = "";
		auinit1 = "";
		issue = "";
		epn = "";
		ppn = "";
		publisher = "";
		placepub = "";
		sid = "";
		doi = "";
		recordid = "";
		date = -1;
		volume = "";
		thVolume = -1;
		thIssue = -1;
		spage = "";
		pages = "";
		location = "";
	}

	public String toString(){
		String result = "genre=" + genre;
		result += ", title=" + title;
		result += ", atitle=" + atitle;
		result += ", aulast=" + aulast;
		result += ", aufirst=" + aufirst;
		result += ", auinit1=" + auinit1;
		result += ", issn=" + issn;
		result += ", isbn=" + isbn;
		result += ", epn="+ epn;
		result += ", ppn="+ ppn;
		result += ", publisher="+ publisher;
		result += ", placepub="+ placepub;
		result += ", sid="+ sid;
		result += ", id=doi:"+ doi;
		result += ", recordid="+ recordid;
		result += ", date="+ date;
		result += ", volume=" + volume;
		result += ", issue=" + issue;
		result += ", location=" + location;
		result += ", thIssue=" + thIssue;
		result += ", thVolume=" + thVolume;
		result += ", spage=" + spage;
		result += ", pages=" + pages;
		return result;
	}

	private void filterForgetAbouts() {
		if ( Locator.forgetAbout == null ){
			Locator.forgetAbout = new HashSet<String>();
			String words = Locator.locatorConfig.getProperty("forgetAbout","");
			if ( !words.equals("") ){
				String [] parts = words.split(",");
				for ( int i=0; i < parts.length; ++i ){
					Locator.forgetAbout.add(parts[i].trim());
				}
			}
			Locator.logger.debug("filled forgetAbout list: " + Locator.forgetAbout.toString() );
		}
		Iterator<String> it = Locator.forgetAbout.iterator();
		while ( it.hasNext() ){
			String what = it.next();
			Locator.logger.debug("try to Forget all about '" + what + "'" );
			if ( what.equals("issn") )
				issn = "";
			else if ( what.equals("isbn") )
				issn = "";
			else if ( what.equals("date") )
				date = -1;
			else if ( what.equals("spage") )
				spage = "";
			else if ( what.equals("aufirst") )
				aufirst = "";
			else if ( what.equals("aulast") )
				aulast = "";
			else if ( what.equals("auinit1") )
				auinit1 = "";
			else if ( what.equals("atitle") )
				atitle = "";
			else if ( what.equals("title") )
				title = "";
			else if ( what.equals("epn") )
				epn = "";
			else if ( what.equals("ppn") )
				ppn = "";
			else if ( what.equals("genre") )
				genre = "";
			else if ( what.equals("issue") ){
				issue = "";
				thIssue = -1;
			}
			else if ( what.equals("location") )
				location = "";
			else if ( what.equals("publisher") )
				publisher = "";
			else if ( what.equals("placepub") )
				placepub = "";
			else if ( what.equals("sid") )
				sid = "";
			else if ( what.equals("doi") )
				doi = "";
			else if ( what.equals("recordid") )
				recordid = "";
			else if ( what.equals("pages") )
				pages = "";
			else if ( what.equals("volume") ){
				volume = "";
				thVolume = -1;
			}
			else
				Locator.logger.warn("Unable to forget '" + what + "' unknown or unimplemented value!");
		}
	}


	public boolean parseQuery( HttpServletRequest rec ) throws LocatorException {
		String query = rec.getQueryString();
		query = query.replaceFirst("^\\?*", ""); // be patient with errors like .../Locator??genre=book&title=....
		if ( query != null ){
			if ( Locator.locatorConfig.getProperty("transactionLogging", "false" ).equals("true") )
				Locator.logger.info( "query: " + query );
			else
				Locator.logger.debug( "query: " + query );
			String [] attVals = query.split("&");
			Map<String,String> parameters = null;
			if ( attVals.length > 0 ){
				parameters = new HashMap<String,String>();
				for( int i=0; i < attVals.length; ++i ){
					String [] parts = attVals[i].split("=");
					if ( parts.length > 1 ){
						try {
							String val = URLDecoder.decode( parts[1], "UTF8");
							parameters.put(parts[0], val );
						} catch (Exception e) {
							Locator.logger.debug("UrlDecoder failed on:" + parts[1]);
							throw new LocatorException("parameter="+parts[1]);
						}
					}
				}
				String par = parameters.get("genre" );
				if ( par != null && par.length() > 0 )
					genre = par;
				par = parameters.get( "issn" );
				if ( par != null && par.length() > 0 ){
					issn = par.trim();
					issn = issn.replaceAll("-", "");
				}
				par = parameters.get( "isbn" );
				if ( par != null && par.length() > 0 ){
					isbn = par.trim();
					isbn = isbn.replaceAll("-", "");
					if ( !( isbn.length() == 10 || isbn.length() == 13 ) ){
						Locator.logger.debug("Ignoring isbn '" + isbn + "' of invalid length " + isbn.length() );
						isbn = "";
					}
				}
				par = parameters.get( "location" );
				if ( par != null && par.length() > 0 )
					location = par;
				par = parameters.get( "title" );
				if ( par != null && par.length() > 0 )
					title = par;
				par = parameters.get( "atitle" );
				if ( par != null && par.length() > 0 ){
					atitle = par;
				}
				par = parameters.get( "aulast" );
				if ( par != null && par.length() > 0 ){
					aulast = par;
				}
				par = parameters.get( "aufirst" );
				if ( par != null && par.length() > 0 ){
					aufirst = par;
				}
				par = parameters.get( "auinit1" );
				if ( par != null && par.length() > 0 ){
					auinit1 = par;
				}
				par = parameters.get( "epn" );
				if ( par != null && par.length() > 0 )
					epn = par;
				par = parameters.get( "ppn" );
				if ( par != null && par.length() > 0 )
					ppn = par;
				par = parameters.get( "publisher" );
				if ( par != null && par.length() > 0 )
					publisher = par;
				par = parameters.get( "placepub" );
				if ( par != null && par.length() > 0 )
					placepub = par;
				par = parameters.get( "sid" );
				if ( par != null && par.length() > 0 )
					sid = par;
				par = parameters.get( "id" );
				if ( par != null && par.length() > 0 ){
					if ( par.startsWith("doi:") )
						doi = par.substring(4);
				}
				par = parameters.get( "recordid" );
				if ( par != null && par.length() > 0 )
					recordid = par;
				par = parameters.get( "spage" );
				if ( par != null && par.length() > 0 ){
					Pattern braces = Pattern.compile("^\\d+");
					Matcher myMatch = braces.matcher(par);
					String match = "";
					if ( myMatch.find() ){
						match = myMatch.group(0);
						Locator.logger.debug( "final spage match = " + match );
						spage = match;
					}
					else
						spage	 = par;
				}
				par = parameters.get( "pages" );
				if ( par != null && par.length() > 0 )
					pages = par;
				try{
					par = parameters.get( "date" );
					if ( par != null && par.length() > 0 )
						date = Integer.parseInt( par );
				}
				catch( NumberFormatException e ){
					Locator.logger.debug( "Integer.parse() failed on:" + par );
				}
				try{
					par = parameters.get( "volume" );
					if ( par != null && par.length() > 0 ){
						volume = par;
						thVolume = guessVolume( volume );
					}
				}
				catch( NumberFormatException e ){
					Locator.logger.debug( "Integer.parse() failed on:" + par );
				}
				try{
						par = parameters.get( "issue" );
						if ( par != null && par.length() > 0 ) {
							issue = par;
							thIssue = guessIssue( issue );
						}
				}
				catch( NumberFormatException e ){
					Locator.logger.debug( "Integer.parse() failed on:" + par );
				}
			}
		}
		filterForgetAbouts( );
		return true;
	}

	private int guessVolume(String par ) throws NumberFormatException {
		int result = -1;
		try {	
			result = Integer.parseInt( par );
		}
		catch( NumberFormatException e ){
			// no avail
			// try harder
			String[] parts = par.split(" ");
			if ( parts.length > 1 ){
				// volumes like: '11 Suppl 1'
				Locator.logger.warn("Guessing volume from '" + par + "'. Try '" + parts[0] + "' to determine Volume." );
				result = Integer.parseInt( parts[0] );
			}
			else {
				// volumes like 2008/3
				parts = par.split("/");
				int last = parts.length - 1;
				if ( last > 0 ){
					Locator.logger.warn("Guessing volume from '" + par + "'. Try '" + parts[last] + "' to determine Volume." );
					result = Integer.parseInt( parts[last] );
				}
				else {
					// volumes like 237-239
					parts = par.split("-");
					if ( parts.length > 0 ){
						Locator.logger.warn("Guessing volume from '" + par + "'. Try '" + parts[0] + "' to determine Volume." );
						result = Integer.parseInt( parts[0] );
					}
				}
			}
		}
		return result;
	}

	private int guessIssue(String par) throws NumberFormatException {
		int result = -1;
		try {	
			result = Integer.parseInt( par );
		}
		catch( NumberFormatException e ){
			// no simple integer
			// try harder
			String[] parts = par.split("-");
			if ( parts.length > 1 ){
				// issues like: '2008-12 and 2-3'
				if ( parts[0].length() == 4 ){
					// it smells like a year
					Locator.logger.warn("Guessing issue from '" + par + "'. Try '" + parts[1] + "' to determine issue." );
					result = Integer.parseInt( parts[1] );
				}
				else {
					Locator.logger.warn("Guessing issue from '" + par + "'. Try '" + parts[0] + "' to determine issue." );
					result = Integer.parseInt( parts[0] );
				}
			}
			else {
				Pattern startnumbers = Pattern.compile("^\\d+");
				Matcher myMatch = startnumbers.matcher(par);
				String match = "";
				if ( myMatch.find() ){
					match = myMatch.group(0);
					Locator.logger.debug( "final issue starting match = " + match );
					result = Integer.parseInt(match);
				}
				else {
					// last resort
					Pattern endnumbers = Pattern.compile(".?(\\d+)$");
					myMatch = endnumbers.matcher(par);
					match = "";
					if ( myMatch.find() ){
						match = myMatch.group(1);
						Locator.logger.debug( "final issue ending match = " + match );
						result = Integer.parseInt(match);
					}

				}
			}
		}
		return result;
	}

}
