package nl.uvt.locator;

import java.util.HashSet;
import java.util.Iterator;

public class CQLConnection {

		public static String makeCQL( QueryData pQ, CQLfields cqlData ){
		String query = "";
		if ( !pQ.epn.equals("") ) {
			Locator.logger.debug("direct search with EPN: " + pQ.epn );
			query = cqlData.epnSelector + pQ.epn;
		}
		else if ( pQ.genre.equals( "journal") ){
			// this is so wrong! We only support journal lookups with EPN
			return "";
		}
		else if ( pQ.genre.equals( "article") ){
			if ( pQ.issn.length() > 0 ){
				query = cqlData.issnSelector + pQ.issn;
				if ( pQ.location.length() > 0 ){
					String location = fixLocation( pQ.location );
					query += " and " + cqlData.locationSelector + "\"" + location + "\"";
				}
			}
			else if ( pQ.title.length() > 0 ){
				StringBuffer main = new StringBuffer();
				StringBuffer sub = new StringBuffer();
				String title = filterTitle( pQ.title );
				splitTitle( title, main, sub );
				title = main.toString();
				title = filterStopWords( title );
				if ( cqlData.currentPrefix.equals("tucat.")	)
					title = picaFixTitle( title );
				query = cqlData.fullTitleSelector + "\"" + title + "\"";
			}
		}
		else if ( pQ.isbn.length() > 0 ){
			Locator.logger.debug("ISBN: " + pQ.isbn );
			if ( pQ.isbn.length() == 13 ){
				Locator.logger.debug("ISBN: is lang genoeg " + pQ.isbn.length() );
				query = cqlData.isbnSelector + pQ.isbn;
			}
			else if ( pQ.isbn.length() == 10 ){
				Locator.logger.debug("ISBN verlengen " );
				String isbn13 = to13( pQ.isbn );
				query = cqlData.isbnSelector + pQ.isbn + " or " + cqlData.isbnSelector + isbn13;						
			}
		}
		else if ( pQ.location.length() > 0 ){
			String location = fixLocation( pQ.location );
			query = cqlData.locationSelector + "\"" + location + "\"";
		}
		else {
			String fullTitle = null;
			String mainTitle = "";
			String subTitle = "";
			if ( !pQ.genre.equals( "preprint") && pQ.title.length() > 0 ) {
				fullTitle = filterTitle( pQ.title );
				StringBuffer main = new StringBuffer();
				StringBuffer sub = new StringBuffer();
				splitTitle( fullTitle, main, sub );
				mainTitle = main.toString();
				subTitle = sub.toString();
			}
			else if ( pQ.atitle.length() > 0 ) {
				fullTitle = filterTitle( pQ.atitle );
				mainTitle = fullTitle;
			}
			if ( cqlData.currentPrefix.equals("tucat.")){
				fullTitle = picaFixTitle( fullTitle );
				mainTitle = picaFixTitle( mainTitle );
				subTitle = picaFixTitle( subTitle );
			}
			String author = null;
			if ( !pQ.genre.equals("bookitem") && 	
					!pQ.genre.equals("proceeding") &&
					pQ.aulast.length() > 0 ){
				author = cqlData.authorSelector + "\"" + pQ.aulast + "\""; 
			}
			String date = null;
			if ( pQ.date > 0 ) {
				date = cqlData.dateSelector + "\"" + pQ.date + "\""; 
			}
			if ( fullTitle != null ) {
				if ( !mainTitle.equals("") ){
					if ( subTitle.equals("") ){
						query = cqlData.titleSelector + "\"" + mainTitle + "\"";
					}
					else {
						query = cqlData.titleSelector + "\"" + mainTitle + "\" and " + cqlData.subTitleSelector + "\"" + subTitle + "\"";
					}
				}
			}
			if ( author != null ){
				if ( query == null )
					query = author;
				else
					query += " and " + author;
			}
			if ( query != null && date != null )
				query += " and " + date;
		}
		return query;
	}


	public static String picaFixTitle (String title) {
		// pica supports only strings of 64 chars, it seems
		String result = title;
		if ( title.length() > 64 ){
			int pos = result.lastIndexOf(' ');
			while ( pos > 0 && pos > 64 ){
				pos = result.lastIndexOf(' ', pos-1 );
			}
			if ( pos > 0 )
				result = result.substring(0,pos);
			else
				// very strange a title of 64 characters without space
				result = result.substring(0,63);
			Locator.logger.debug("fixed up title from '" + title + "' to '" + result + "'");
		}
		return result;
	}

	static String to13(String isbn) {
		Locator.logger.debug( "ISBN10to13 :"+ isbn );
		if ( isbn.length() < 10 ){
			Locator.logger.debug( "isbn is to short!");
			return isbn;
		}
		String NUMVALUES = "0123456789";
		String work = isbn.substring(0, 9);
		work = "978" + work;
		char[] bytes = work.toCharArray();
		boolean three = false;
		int checksum = 0;
		for ( int i=0; i < 12; ++i ){
			if ( three )
				checksum += 3 * NUMVALUES.indexOf(bytes[i]);
			else
				checksum += 1 * NUMVALUES.indexOf(bytes[i]);
			three = !three;
		}
		int rem = checksum % 10;
		int last = 0;
		if ( rem != 0 )
			last = 10 - rem;
		String result = new String(bytes) + last;
		Locator.logger.debug( "ISBN10to13 gives "+ result );
		return result;
	}

	public static void splitTitle(String title, StringBuffer main,	StringBuffer sub) {
		String titleSep = Locator.locatorConfig.getProperty( "subTitleSeparator", "" );
		titleSep = titleSep.replaceAll("\"","");
		Locator.logger.debug("separator = '"+titleSep+"'" );
		String titleParts[] = title.split( titleSep, 2 );
		if ( titleParts.length > 1 ){
			for( int i=0; i < titleParts.length; ++i ){
				titleParts[i] =	titleParts[i].trim();
				Locator.logger.debug( "splitTitle part["+i+"]= '"+titleParts[i] +"'");
			}
			main.append( titleParts[0] );
			sub.append( titleParts[1] );
		}
		else
			main.append( title );
	}

	public static String fixLocation( String loc ) {
		String result = loc.replaceAll("/\\d{4}.*", "/...");
		if ( !loc.equals(result))
			Locator.logger.debug("fixLocation replaced '" + loc + "' by: '" + result + "'" );			
		return result;
	}

	public static String filterTitle( String query ) {
		String result = query;
		if ( Locator.filterChars == null ){
			Locator.filterChars = Locator.locatorConfig.getProperty("filterChars","[\"]");
		}
		if ( Locator.filterChars != null ){
			try {
				result = result.replaceAll( Locator.filterChars, "");
			}
			catch ( Exception e ){
				Locator.logger.warn( "filterTitle failed! Something wrong with filterChars regExp? " + Locator.filterChars );  
			}
		}
		if ( !result.equals(query) )
			Locator.logger.debug("removed unwanted chars " + Locator.filterChars + " in '" + query +"' ==> '" + result +"'" );
		return result;
	}

	public static String filterStopWords( String query ) {
		//  stopwords are assumed to be lowercase. 
		String result = query.toLowerCase();
		if ( Locator.stopWords == null ){
			Locator.stopWords = new HashSet<String>();
			String words = Locator.locatorConfig.getProperty("stopWords","");
			if ( words.equals("") ){
				// hardwired default
				Locator.logger.warn("PLEASE FIX THIS: NO stopWords found in configfile." );
				Locator.logger.warn("PLEASE FIX THIS: we don't use stopwords." );
			}
			String [] doiS = words.split(",");
			for ( int i=0; i < doiS.length; ++i ){
				Locator.stopWords.add(doiS[i].trim());
			}
			Locator.logger.debug("filled Known stopWords list: " + Locator.stopWords.toString() );
		}
		Iterator<String> it = Locator.stopWords.iterator();
		while ( it.hasNext() ){
			result = result.replaceFirst("^" + it.next() + " ", "");
		}
		if ( !result.equals(query) )
			Locator.logger.debug("replaced stopwords in '" + query +"' ==> '" + result +"'" );
		return result;
	}


}
