package nl.uvt.locator;

import java.net.URL;
import java.util.Properties;

import nu.xom.Document;
import nl.uvt.commons.io.*;

public class AvailabilityConnection {

	Document query( String epn ) throws LocatorException {
		Document result = null;
		String urlString = Locator.locatorConfig.getProperty("availabilityUri");
		// send getAvailability requests to a capable mps 
		try {
			URL url = new URL( urlString );
			Properties props = new Properties();
			props.setProperty("id", epn );
			props.setProperty("id_type", "bib" );
			result = Http.httpGetDocument( url, props, Locator.httpConfig );
//					Locator.logger.debug( "availability doc:" + result.toXML());
			}					
		catch ( Exception e) {
			throw new LocatorException( "Availability URL: '" + urlString + "' failed"); 
		}
		return result;
	}

}
