# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package UvT::NOC::Config::SettingList;

use UvT::NOC::Config::Setting;
use Data::Dumper;

use Clarity -base;

field settings => {};

sub addSetting
{
    my ($self, $setting) = @_;

    return unless defined $setting;

    if($self->hasSetting($setting))
	{
        warn("### Warning : Setting '" . $setting->name . "' already exists in SettingList! Setting not added!");
        return;
    }

	$self->settings->{$setting->name} = $setting;
}

sub removeSetting
{
	my ($self, $setting) = @_;

	return unless defined $setting;

	my $name = ref $setting ? $setting->name : $setting;

	delete $self->settings->{$name};
}

sub hasSetting
{
	my ($self, $setting) = @_;

	my $settingName = ref $setting ? $setting->name : $setting;

	return defined $self->getSetting($settingName);
}

sub getSetting
{
	my ($self, $name) = @_;

	return unless defined $name;

	return $self->settings->{$name};
}

sub getSettings
{
    my ($self) = @_;

	return values %{$self->settings};
}

sub removeAllSettings
{
    my ($self) = @_;

    delete $self->{settings};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->settings};
}

sub toString
{
	my($self) = @_;
    my $string = "";

    my @settings = $self->getSettings();
    for my $i (0..$#settings)
    {
        $string .= "setting=[" . $settings[$i]->toString() . "]" . ( $i < $#settings ? "\n" : ""); 
    }

    return $string;
}

use overload '""' => \&toString;

1;

