use strict;
use warnings FATAL => 'all';

package NOC::Net::SSH2;

use Net::SSH2;
use Exporter qw(import);

our @EXPORT = qw(getInfoBySSHCliCommand);
our @EXPORT_OK = @EXPORT;


# Functienaam : getInfoBySSHCliCommand 
#
# Parameters : (4x)
#       1) ip adres van het device om uit te lezen
#	2) ssh username
#	3) ssh password
#	4) ssh commando
#
# Omschrijving :
#	Functie om data uit te lezen via ssh

sub getInfoBySSHCliCommand
{
        my ($ip, $username, $password, $command) = @_;

        local $SIG{ALRM} = sub { die "" };
        alarm 5;

        my $ssh2 = Net::SSH2->new();
        $ssh2->connect($ip) or die "Can't connect to $ip : $!\n";
        $ssh2->auth_password($username, $password) or die "Authentication failed: $!\n";

        my $output = ''; my $buffer;
        my $chan = $ssh2->channel();
        $chan->exec("$command") or die "Couldn't exec '$command': $!\n";
        while ( ! $chan->eof() )
        {
                $chan->read($buffer, 1);
                $output .= $buffer;
        }
        $chan->close();
        $ssh2->disconnect();

        $output =~ s/^.*?Password://s;
        $output =~ s/quit.*?$//s; 

        alarm 0; #cancel the alarm if does not hang

        return $output; 
}

