# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package UvT::NOC::Config::Resource;

use Clarity -base;
#use UvT::NOC::Config::Property;
use Data::Dumper;

field name;
field properties => {};

sub new
{
	my($class, $name) = @_;

	return super(
		name => $name
	);
}

sub addProperty
{
    my ($self, $property) = @_;

    return unless defined $property;

    if($self->hasProperty($property))
	{
        warn("### Warning : Property '" . $property->name . "' already exists in Resource! Property not added!");
        return;
    }

	$self->properties->{$property->name} = $property;
}

sub removeProperty
{
	my ($self, $property) = @_;

	return unless defined $property;

	my $propertyName = ref $property ? $property->name : $property;

	delete $self->properties->{$propertyName};
}

sub hasProperty
{
	my ($self, $property) = @_;

	my $propertyName = ref $property ? $property->name : $property;

	return defined $self->getProperty($propertyName);
}

sub getProperty
{
	my ($self, $name) = @_;

	return unless defined $name;

	return $self->properties->{$name};
}

sub getProperties
{
    my ($self) = @_;

	return values %{$self->properties};
}

sub removeAllProperties
{
    my ($self) = @_;

    delete $self->{properties};
}

sub toString
{
	my ($self) = @_;
	# TODO
	return "name=" . $self->name;
}

use overload '""' => \&toString;

1;
