# $Id: Config.pm 7765 2013-05-23 13:11:34Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/libuvt-noc-perl/lib/UvT/NOC/Config.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package NOC::Config;

use Clarity -base;

use XML::LibXML;

field configfile;
field doc;

sub new
{
	my($class, $configfile) = @_;

	return super(
		configfile => $configfile,
		doc => XML::LibXML->new()->parse_file($configfile)
	);
}

sub getConfig
{
	my($self, $node_name) = @_;

	my %hash = ();
	my $doc = $self->doc;

	die "Cannot find node $node_name\n"
		unless $doc->exists('/*/' . $node_name);

	foreach my $node ($doc->findnodes('/*/' . $node_name . '/*'))
	{
		$hash{$node->nodeName} = $node->textContent;
	}
	return \%hash;
}

sub getConfigNodes
{
	my ($self) = @_;
	my $doc = $self->doc;

	my @nodeList = ();
	
	foreach my $node ($doc->findnodes('/*/*'))
	{
		push(@nodeList, $node->getName);	
	}

	return @nodeList;
}

1;




