use strict;
use warnings FATAL => 'all';

package UvT::NOC::Tracking::Vlan;

use Clarity -base;

field id;
field macAddress => {};

sub new
{
        my($class, $id) = @_;

        return super(
                        id => $id,
        );
}

sub addMacAddress
{
        my ($self, $mac) = @_;

        return unless defined $mac;

        if ($self->hasMacAddress($mac))
        {
                warn("WARNING : Mac address '$mac->macAddress' already exists on vlan '" . $self->id . "'. Mac address not added!");
                return;
        }

        $self->macAddress->{$mac->macAddress} = $mac;
}

sub hasMacAddress
{
        my ($self, $mac) = @_;

	my $macAddress = ref $mac ? $mac->macAddress : $mac;

        return defined $self->getMacAddress($macAddress);
}

sub getMacAddress
{
        my ($self, $mac) = @_;

        return unless defined $mac;

        return $self->macAddress->{$mac};
}

sub getMacAddresses
{
        my ($self) = @_;

        return values %{$self->macAddress};
}

sub removeMacAddress
{
        my ($self, $mac) = @_;

        return unless defined $mac;

        delete $self->macAddress->{$mac};
}

sub removeAllMacAddresses
{
        my ($self) = @_;

        delete $self->{macAddress};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->macAddress};
}

sub toString
{
        my ($self) = @_;

        my $string = "vlan=" . $self->id . ", mac addresses=[";

        my @macs = $self->getMacAddresses();
        for my $i (0..$#macs)
        {
                $string .= "[" . $macs[$i]->toString() . "]" . ( $i < $#macs ? ", " : "");
        }
        $string .= "]";
        return $string;

}


use overload '""' => \&toString;

1;
