use strict;
use warnings FATAL => 'all';

package UvT::NOC::Tracking::UserTrackingData;

use Time::Local;
use Clarity -base;

field trackingServer;
field creationDate;
field network => {};

sub new
{
        my($class, $trackingServer, $creationDate) = @_;

	my %month;
	@month{ qw/Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec/ } = 0..11;


	my ($dayOfWeek, $month, $day, $hour, $minute, $second, $year) =
                $creationDate =~ m{(...) (...) (..) (..):(..):(..) CEST (....)};

	#print ">>$creationDate<<";
	#my $t = timelocal($second, $minute, $hour, $day, $month{$month}, $year);
	#print ">>>" . localtime($t) . "<<<";

        return super(
                        trackingServer => $trackingServer,
			creationDate => timelocal($second, $minute, $hour, $day, $month{$month}, $year),
        );
}

sub addNetwork
{
        my ($self, $network) = @_;

        return unless defined $network;

        if ($self->hasNetwork($network))
        {
                warn("WARNING : Network '$network->name' already exists on!. Network not added!");
                return;
        }

        $self->network->{$network->name} = $network;
}

sub hasNetwork
{
        my ($self, $network) = @_;

	my $networkName = ref $network ? $network->name : $network;

        return defined $self->getNetworkByName($networkName);
}

sub getNetworkByName
{
        my ($self, $name) = @_;

        return unless defined $name;

        return $self->network->{$name};
}

sub getNetworks
{
        my ($self) = @_;

        return values %{$self->network};
}

sub removeNetwork
{
        my ($self, $network) = @_;

        return unless defined $network;

        my $name = ref $network ? $network->name : $network;

        delete $self->network->{$name};
}

sub removeNetworks
{
        my ($self) = @_;

        delete $self->{network};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->network};
}

sub info
{
        my ($self) = @_;

		my $string = "";

		my @networks = $self->getNetworks();
		for my $i (0..$#networks)
		{
				$string .= "Data found by LMS : " . $networks[$i]->size . " vlan(s) and " . $networks[$i]->countMacAddresses . " mac address(es) on network " . $networks[$i]->name . "\n";
		}

		return $string;

}

sub toString
{
        my ($self) = @_;

        my $string = "usertracking server=" . $self->trackingServer . ", networks=[";

        my @networks = $self->getNetworks();
        for my $i (0..$#networks)
        {
                $string .= "[" . $networks[$i]->toString() . "]" . ( $i < $#networks ? ", " : "");
        }
        $string .= "]";
        return $string;
}


use overload '""' => \&toString;

1;
