# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package UvT::NOC::MacRegistration::UvTRegList;

use UvT::NOC::MacRegistration::UvTRegistration;

use Clarity -base;

field registrations => {};

sub addRegistration
{
    my ($self, $registration) = @_;

    return unless defined $registration;

    if($self->hasRegistration($registration))
	{
        warn("### Warning : Mac address registration '" . $registration->mac . "' already exists in UvTRegList! Registration not added!");
        return;
    }

	$self->registrations->{$registration->mac} = $registration;
}

sub removeRegistration
{
	my ($self, $registration) = @_;

	return unless defined $registration;

	my $mac = ref $registration ? $registration->mac : $registration;

	delete $self->registrations->{$mac};
}

sub hasRegistration
{
	my ($self, $registration) = @_;

	return defined $self->getRegistration($registration->mac);
}

sub getRegistration
{
	my ($self, $mac) = @_;

	return unless defined $mac;

	return $self->registrations->{$mac};
}

sub getRegistrations
{
    my ($self) = @_;

	return values %{$self->registrations};
}

sub removeAllRegistrations
{
    my ($self) = @_;

    delete $self->{registrations};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->registrations};
}

sub toString
{
	my($self) = @_;
    my $string = "";  #"[ ";

    my @registrations = $self->getRegistrations();
    for my $i (0..$#registrations)
    {
        $string .= "registration=[" . $registrations[$i]->toString() . "]" . ( $i < $#registrations ? "\n" : ""); 
    }

    #$string .= " ]";
    return $string;
}

use overload '""' => \&toString;

1;

