use strict;
use warnings FATAL => 'all';

package UvT::NOC::Tracking::Network;

use Clarity -base;

field name;
field vlan => {};

sub new
{
        my($class, $name) = @_;

        return super(
                        name => $name,
        );
}

sub addVlan
{
        my ($self, $vlan) = @_;

        return unless defined $vlan;

        if ($self->hasVlan($vlan))
        {
                warn("WARNING : Vlan '$vlan->id' already exists on network '" . $self->name . "'. Vlan not added!");
                return;
        }

        $self->vlan->{$vlan->id} = $vlan;
}

sub hasVlan
{
        my ($self, $vlan) = @_;

        my $vlanId = ref $vlan ? $vlan->id : $vlan;

        return defined $self->getVlanById($vlanId);
}

sub getVlanById
{
        my ($self, $id) = @_;

        return unless defined $id;

        return $self->vlan->{$id};
}

sub getVlans
{
        my ($self) = @_;

        return values %{$self->vlan};
}

sub removeVlan
{
        my ($self, $vlan) = @_;

        return unless defined $vlan;

        my $id = ref $vlan ? $vlan->id : $vlan;

        delete $self->vlan->{$id};
}

sub removeVlans
{
        my ($self) = @_;

        delete $self->{vlan};
}

sub countMacAddresses
{
        my ($self) = @_;

        my $nMac = 0;

        my @vlans = $self->getVlans();
        for my $i (0..$#vlans)
        {
                $nMac += $vlans[$i]->size();
        }

		return $nMac;
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->vlan};
}

sub toString
{
        my ($self) = @_;

        my $string = "network=" . $self->name . ", vlans=[";

        my @vlans = $self->getVlans();
        for my $i (0..$#vlans)
        {
                $string .= "[" . $vlans[$i]->toString() . "]" . ( $i < $#vlans ? ", " : "");
        }
        $string .= "]";
        return $string;

}


use overload '""' => \&toString;

1;
