# $Id: $
# $URL: $

use strict;
use warnings FATAL => 'all';

package UvT::NOC::InfraStructure::EquipmentRoom;

use UvT::NOC::InfraStructure::Outlet;

use Clarity -base;

field number;
field outlets => {};

sub new
{
	my($class, $number) = @_;

	return super(
		number => $number,
	);
}

sub addOutlet
{
	my ($self, $outlet) = @_;

	return unless defined $outlet;

	if ($self->hasOutlet($outlet))
	{
		    warn("WARNING : Outlet '$outlet->number' already exists at equipment room '" . $self->number . "'. Outlet not added!");
		    return;
	}

	$self->outlets->{$outlet->number} = $outlet;
}

sub removeOutlet
{
	my ($self, $outlet) = @_;

	return unless defined $outlet;

	my $number = ref $outlet ? $outlet->number : $outlet;

	delete $self->outlets->{$number};
}

sub hasOutlet
{
	my ($self, $outlet) = @_;

	my $number = ref $outlet ? $outlet->number : $outlet;

	return defined $self->getOutlet($number);
}


sub getOutlet
{
	my ($self, $number) = @_;

	return unless defined $number;

	return $self->outlets->{$number};
}

sub getOutlets
{
	my ($self) = @_;

	return values %{$self->outlets};
}

sub removeAllOutlets
{
	my ($self) = @_;

	delete $self->{outlets};
}

sub getLowestOutletNumber
{
	my ($self) = @_;

	my @sortedOutlets = sort { $a->number <=> $b->number } $self->getOutlets;

	return $sortedOutlets[0]->number;
}

sub getHighestOutletNumber
{
	my ($self) = @_;

	my @sortedOutlets = sort { $a->number <=> $b->number } $self->getOutlets;

	return $sortedOutlets[$#sortedOutlets]->number;
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->outlets};
}

sub toString
{
	my ($self) = @_;

	my $string = "number=" . $self->number . ", outlets=[";

	my @outlets = $self->getOutlets();
	for my $i (0..$#outlets)
	{
		$string .= "[" . $outlets[$i]->toString() . "]" . ( $i < $#outlets ? ", " : "");
	}

	$string .= "]";
	return $string;
}

use overload '""' => \&toString;

1;
