# $Id: $
# $URL: $

use strict;
use warnings FATAL => 'all';

package UvT::NOC::InfraStructure::BuildingList;

use UvT::NOC::InfraStructure::Building;

use Clarity -base;

field buildings => {};

sub addBuilding
{
    my ($self, $building) = @_;

    return unless defined $building;

    if($self->hasBuilding($building))
	{
        warn("### Warning : Building '" . $building->acronym . "' already exists in BuildingList! Building not added!");
        return;
    }

	$self->buildings->{$building->acronym} = $building;
}

sub removeBuilding
{
	my ($self, $building) = @_;

	return unless defined $building;

	my $acronym = ref $building ? $building->acronym : $building;

	delete $self->buildings->{$acronym};
}

sub hasBuilding
{
	my ($self, $building) = @_;

	my $acronym = ref $building ? $building->acronym : $building;

	return defined $self->getBuilding($acronym);
}

sub getBuilding
{
	my ($self, $acronym) = @_;

	return unless defined $acronym;

	return $self->buildings->{$acronym};
}

sub getBuildings
{
    my ($self) = @_;

	return values %{$self->buildings};
}

sub removeAllBuildings
{
    my ($self) = @_;

    delete $self->{buildings};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->buildings};
}

sub toString
{
	my($self) = @_;
    my $string = "";

    my @buildings = $self->getBuildings();
    for my $i (0..$#buildings)
    {
        $string .= "building=[" . $buildings[$i]->toString() . "]" . ( $i < $#buildings ? "\n" : ""); 
    }

    return $string;
}

use overload '""' => \&toString;

1;

