# $Id: $
# $URL: $

use strict;
use warnings FATAL => 'all';

package UvT::NOC::InfraStructure::Building;

use UvT::NOC::InfraStructure::EquipmentRoom;

use Clarity -base;

field acronym;
field equipmentRooms => {};

sub new
{
	my($class, $acronym) = @_;

	return super(
		acronym => $acronym,
	);
}

sub addEquipmentRoom
{
	my ($self, $equipmentRoom) = @_;

	return unless defined $equipmentRoom;

	if ($self->hasEquipmentRoom($equipmentRoom))
	{
		    warn("WARNING : Equipment room '$equipmentRoom->number' already exists at building '" . $self->acronym . "'. Equipment room not added!");
		    return;
	}

	$self->equipmentRooms->{$equipmentRoom->number} = $equipmentRoom;
}

sub removeEquipmentRoom
{
	my ($self, $equipmentRoom) = @_;

	return unless defined $equipmentRoom;

	my $number = ref $equipmentRoom ? $equipmentRoom->number : $equipmentRoom;

	delete $self->equipmentRooms->{$number};
}

sub hasEquipmentRoom
{
	my ($self, $equipmentRoom) = @_;

	my $number = ref $equipmentRoom ? $equipmentRoom->number : $equipmentRoom;

	return defined $self->getEquipmentRoom($number);
}


sub getEquipmentRoom
{
	my ($self, $number) = @_;

	return unless defined $number;

	return $self->equipmentRooms->{$number};
}

sub getEquipmentRooms
{
	my ($self) = @_;

	return values %{$self->equipmentRooms};
}

sub removeAllEquipmentRooms
{
	my ($self) = @_;

	delete $self->{equipmentRooms};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->equipmentRooms};
}

sub toString
{
	my ($self) = @_;

	my $string = "acronym=" . $self->acronym . ", equipmentRooms=[";

	my @equipmentRooms = $self->getEquipmentRooms();
	for my $i (0..$#equipmentRooms)
	{
		$string .= "[" . $equipmentRooms[$i]->toString() . "]" . ( $i < $#equipmentRooms ? ", " : "");
	}

	$string .= "]";
	return $string;
}

use overload '""' => \&toString;

1;
