use strict;
use warnings FATAL => 'all';

package UvT::NOC::Tracking::TrackingData;

use Time::Local;
use Clarity -base;

field switchIPAddress;
field switchPort;
field timestamp;
field hostIPAddress;

my %LONG = (
    'Fa' => 'FastEthernet',
    'Gi' => 'GigabitEthernet',
    'Te' => 'TenGigabitEthernet',
    'Fo' => 'FortyGigabitEthernet',
    'Po' => 'Port-channel',
    'Eth' => 'Ethernet'

);

my %ABBREV = reverse %LONG;

sub new
{
    my($class, $switchIPAddress, $switchPort, $timestamp, $hostIPAddress ) = @_;

    # shorten interface names when possible (for ap's and unknown abbreviations)
    eval {
        $switchPort = shortInterfaceName($switchPort);
    };

    # uses seconds in stead of milliseconds
    $timestamp = $timestamp / 1000;

    if ($hostIPAddress eq 'NULL_VALUE') {
        $hostIPAddress = '';
    }

    return super(
        switchIPAddress => $switchIPAddress,
        switchPort => $switchPort,
        timestamp => $timestamp,
        hostIPAddress => $hostIPAddress,
    );
}

sub shortInterfaceName
{
    my $longName = shift;

    my ($type, $pos) = $longName =~ qr/(\D+)(.*)/o;
    my $abbrev = $ABBREV{$type};
    
    return "$abbrev$pos";
}

sub toString
{
    my ($self) = @_;

    return "switch ip=" . $self->switchIPAddress . ", switchport=" . $self->switchPort . ", timestamp=" . localtime($self->timestamp) . ", host ip=" . $self->hostIPAddress;
}

use overload '""' => \&toString;

1;
