use strict;
use warnings FATAL => 'all';

package UvT::NOC::Tracking::MACAddress;

use Clarity -base;

field macAddress;
field trackingData => {};

sub new
{
        my($class, $macAddress ) = @_;

	$macAddress =~ s/[^a-zA-Z0-9 ]//g;

        return super(
                        macAddress => lc($macAddress),
        );
}

sub addTrackingData
{
        my ($self, $tdata) = @_;

        return unless defined $tdata;

        if ($self->hasTrackingData($tdata))
        {
                warn("WARNING : Tracking data '$tdata->timestamp' already exists on mac '" . $self->macAddress . "'. Tracking data not added!");
                return;
        }

        $self->trackingData->{$tdata->timestamp} = $tdata;
}

sub hasTrackingData
{
        my ($self, $tdata) = @_;

        return defined $self->getTrackingDataByTimestamp($tdata->timestamp);
}

sub getTrackingDataByTimestamp
{
        my ($self, $timestamp) = @_;

        return unless defined $timestamp;

        return $self->trackingData->{$timestamp};
}

sub getMostRecentTrackingData
{
	my ($self) = @_;

	my @tData = $self->getAllTrackingData();
        my $mostRecentTrackingData = $tData[0];
        for my $i (1..$#tData)
        {
		if ($tData[$i]->timestamp > $mostRecentTrackingData->timestamp) { $mostRecentTrackingData = $tData[$i]; }	
        }

	return $mostRecentTrackingData;
}

sub getOldestTrackingData
{
        my ($self) = @_;

        my @tData = $self->getAllTrackingData();
        my $mostRecentTrackingData = $tData[0];
        for my $i (1..$#tData)
        {
                if ($tData[$i]->timestamp < $mostRecentTrackingData->timestamp) { $mostRecentTrackingData = $tData[$i]; }
        }

        return $mostRecentTrackingData;
}


sub getAllTrackingData
{
        my ($self) = @_;

        return values %{$self->trackingData};
}

sub removeAllTrackingData
{
        my ($self) = @_;

        delete $self->{trackingData};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->trackingData};
}

sub toString
{
        my ($self) = @_;

        my $string = "mac address=" . $self->macAddress . ", trackingData=[";

        my @tData = $self->getAllTrackingData();
        for my $i (0..$#tData)
        {
                $string .= "[" . $tData[$i]->toString() . "]" . ( $i < $#tData ? ", " : "");
        }
        $string .= "]";
        return $string;

}

use overload '""' => \&toString;

1;
