# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package UvT::NOC::MacRegistration::WMBAddress;

use Clarity -base;

field street;
field number;
field registrations => {};

sub new
{
	my($class, $street, $number) = @_;

	return super(
		            street => $street,
		            number => $number,
	);
}

sub addRegistration
{
    my ($self, $registration) = @_;

    return unless defined $registration;

    if ($self->hasRegistration($registration))
    {
            warn("WARNING : Registration user '" . $registration->name . "' already exists on address '" . $self->street . " "  . $self->number . "'. Registration not added!");
            return;
    }

	my $key = $registration->name . "-" . $registration->mac1 . "-" . $registration->mac2 . "-" . $registration->regDate . "-" . $registration->vlanName;
        
	$self->registrations->{$key} = $registration;
}

sub addRegistrations
{
        my ($self, @registrations) = @_;

	for my $i (0..$#registrations)
	{
		my $registration = $registrations[$i];

		$self->addRegistration($registration);
	}
}

sub hasRegistration
{
    my ($self, $registration) = @_;

	my $key = $registration->name . "-" . $registration->mac1 . "-" . $registration->mac2 . "-" . $registration->regDate . "-" . $registration->vlanName;
	my $registrationKey = ref $registration ? $key : $registration;

    return defined $self->getRegistrationByKey($registrationKey);
}

sub getRegistrationByKey
{
        my ($self, $key) = @_;

        return unless defined $key;

        return $self->registrations->{$key};
}

sub hasMACAddress
{
        my ($self, $mac) = @_;

		return unless defined $mac;

        my @registrations = $self->getRegistrations();
        for my $i (0..$#registrations)
        {
				if ($registrations[$i]->hasMACAddress($mac))
				{
						return defined $mac;
				}
        }
}

sub getRegistrations
{
        my ($self) = @_;

        return values %{$self->registrations};
}

sub removeRegistration
{
        my ($self, $registration) = @_;

        return unless defined $registration;

        my $registrationName = ref $registration ? $registration->name : $registration;

        delete $self->registrations->{$registrationName};
}

sub removeAllRegistrations
{
        my ($self) = @_;

        delete $self->{registrations};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->registrations};
}

sub toString
{
        my ($self) = @_;

        my $string = "address=" . $self->street . " " . $self->number . " , registrations=[";

        my @registrations = $self->getRegistrations();
        for my $i (0..$#registrations)
        {
                $string .= "[" . $registrations[$i]->toString() . "]" . ( $i < $#registrations ? ", " : "");
        }
        $string .= "]";
        return $string;

}

sub toPipedString
{
	my ($self, $prefix) = @_;

	my $string = "";
	my $address = $self->street . ($self->street ne "" ? " " : "") . $self->number;

	my @registrations = $self->getRegistrations();
	for my $i (0..$#registrations)
	{
		my $registration = $registrations[$i];
		if (defined($prefix)) { $string .= $prefix . " "; }
	    $string .= $registration->name . "|" . $address . "|" . $registration->mac1 . "|" . $registration->mac2 . "|" . $registration->regDate . "|" . $registration->vlanName . "\n";
	}

	return $string;
}


use overload '""' => \&toString;

1;
