# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package UvT::NOC::MacRegistration::WMBRegList;

use UvT::NOC::MacRegistration::WMBRegistration;

use Clarity -base;

use constant false => 0;
use constant true  => 1;

field registrations => {};
field registrationsByAddress => {};

sub addRegistration
{
	my ($self, $registration) = @_;

	return unless defined $registration;

	if($self->hasRegistration($registration))
	{
		warn("### Warning : Mac address registration '" . $registration->mac . "' already exists in WMBRegList! Registration not added!");
		return;
	}

	$self->registrations->{$registration->mac} = $registration;
	$self->registrationsByAddress->{$registration->street . " " . $registration->number} = $registration;
}

sub removeRegistration
{
	my ($self, $registration) = @_;

	return unless defined $registration;

	my $mac = ref $registration ? $registration->mac : $registration;

	delete $self->registrations->{$mac};
}

sub hasRegistration
{
	my ($self, $registration) = @_;

	if (defined($registration))
	{
		foreach my $reg ($self->getRegistrations())
		{
			if ($registration->mac eq $reg->mac &&
				 $registration->name eq $reg->name &&
				 $registration->street eq $reg->street &&
				 $registration->number eq $reg->number &&
				 $registration->regDate eq $reg->regDate &&
				 $registration->vlanName eq $reg->vlanName
				) { return true };
		}
	}
}

sub hasAddress
{
	my ($self, $street, $number) = @_;

	return $self->getRegistrationByAddress($street, $number);
}

sub getRegistrationByMac
{
	my ($self, $mac) = @_;

	return unless defined $mac;

	return $self->registrations->{$mac};
}

sub getRegistrationByAddress
{
	my ($self, $street, $number) = @_;

        if (defined($street) && defined($number))
        {
                foreach my $registration ($self->getRegistrations())
                {
                        if ($registration->street eq $street && $registration->number eq $number) { return $registration };
                }
        }
}

sub getRegistrations
{
	my ($self) = @_;

	return values %{$self->registrations};
}

sub getRegistrationsByAddress
{
	my ($self) = @_;

	return values %{self->registrationsByAddress};
}

sub removeAllRegistrations
{
	my ($self) = @_;

	delete $self->{registrations};
}

sub size
{
	my ($self) = @_;

	return scalar keys %{$self->registrations};
}

sub toString
{
	my($self) = @_;
	my $string = "";  #"[ ";

	my @registrations = $self->getRegistrations();
	for my $i (0..$#registrations)
	{
		$string .= "registration=[" . $registrations[$i]->toString() . "]" . ( $i < $#registrations ? "\n" : ""); 
	}

	#$string .= " ]";
	return $string;
}

use overload '""' => \&toString;

1;

