use strict;
use warnings FATAL => 'all';

package UvT::NOC::Tracking::TrackingData;

use Time::Local;
use Clarity -base;

field switchIPAddress;
field switchPort;
field timestamp;
field hostIPAddress;

sub new
{
	my($class, $switchIPAddress, $switchPort, $timestamp, $hostIPAddress ) = @_;

	my ($year, $month, $day, $hour, $minute, $second) =
		$timestamp =~ m{(....)/(..)/(..) (..):(..):(..)};
        
	return super(
        switchIPAddress => $switchIPAddress,
        switchPort => $switchPort,
        timestamp => timelocal($second, $minute, $hour, $day, $month - 1, $year - 1900),
		hostIPAddress => $hostIPAddress,
    );
}

sub toString
{
    my ($self) = @_;

    return "switch ip=" . $self->switchIPAddress . ", switchport=" . $self->switchPort . ", timestamp=" . localtime($self->timestamp) . ", host ip=" . $self->hostIPAddress;
}

use overload '""' => \&toString;

1;
