# $Id: HostList.pm 6701 2012-10-09 12:24:35Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/libnoc-infra-perl/lib/NOC/InfraStructure/HostList.pm $

use strict;
use warnings FATAL => 'all';

package NOC::InfraStructure::HostList;

use NOC::InfraStructure::Host;

use Clarity -base;

field hosts => {};

sub addHost
{
    my ($self, $host) = @_;

    return unless defined $host;

    if($self->hasHost($host))
	{
        warn("### Warning : Host '" . $host->ip . "' already exists in HostList! Host not added!");
        return;
    }

	$self->hosts->{$host->ip} = $host;
}

sub removeHost
{
	my ($self, $host) = @_;

	return unless defined $host;

	my $ip = ref $host ? $host->ip : $host;

	delete $self->hosts->{$ip};
}

sub hasHost
{
	my ($self, $host) = @_;

	return defined $self->getHostByIp($host->ip);
}

sub getHostByIp
{
	my ($self, $ip) = @_;

	return unless defined $ip;

	return $self->hosts->{$ip};
}

sub getHostByName
{
	my ($self, $name) = @_;

	if (defined($name))
	{
		foreach my $host ($self->getHosts())
		{
			foreach my $hostname (@{$host->name})
			{
				if ($hostname eq $name) { return $host };
			}
		}
	}
}

sub getHosts
{
    my ($self) = @_;

	return values %{$self->hosts};
}

sub removeAllHosts
{
    my ($self) = @_;

    delete $self->{hosts};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->hosts};
}

sub toString
{
	my($self) = @_;
    my $string = "";  #"[ ";

    my @hosts = $self->getHosts();
    for my $i (0..$#hosts)
    {
        $string .= "host=[" . $hosts[$i]->toString() . "]" . ( $i < $#hosts ? "\n" : ""); 
    }

    #$string .= " ]";
    return $string;
}

use overload '""' => \&toString;

1;

